﻿unit tb.Open62541.Functions;

interface

uses
  tb.Open62541.Types,
  tb.Open62541.NodeIds,
  tb.Open62541.StatusCodes;

{$MINENUMSIZE 4}

{$IFDEF WIN64}
{$ALIGN 8}
{$ELSE}
{$MESSAGE FATAL '32-Bit wird nicht unterstützt. Bitte als Win64 kompilieren.'}
{$ENDIF}

{$POINTERMATH ON}
{$H+}

const
  LibOpen62541 = 'Open62541.dll';

type
  DWord = LongWord;
  size_t = NativeUInt;

  UA_Boolean = Boolean;
  PUA_Boolean = ^UA_Boolean;

  UA_Byte = Byte;
  PUA_Byte = ^UA_Byte;

  UA_Int16 = Smallint;
  PUA_Int16 = ^UA_Int16;

  UA_UInt16 = Word;
  PUA_UInt16 = ^UA_UInt16;

  UA_Int32 = Integer;
  PUA_Int32 = ^UA_Int32;

  UA_UInt32 = DWord;
  PUA_UInt32 = ^UA_UInt32;

  UA_Int64 = Int64;
  PUA_Int64 = ^UA_Int64;

  UA_UInt64 = UInt64;
  PUA_UInt64 = ^UA_UInt64;

  UA_Float = Single;
  PUA_Float = ^UA_Float;

  UA_Double = Double;
  PUA_Double = ^UA_Double;

  UA_StatusCode = DWord;
  PUA_StatusCode = ^UA_StatusCode;

  UA_String = record
    length: size_t;
    data: PUA_Byte;
  end;
  PUA_String = ^UA_String;

  UA_DateTime = Int64;
  PUA_DateTime = ^UA_DateTime;

  UA_DateTimeStruct = record
    nanoSec: UA_UInt16;
    microSec: UA_UInt16;
    milliSec: UA_UInt16;
    sec: UA_UInt16;
    min: UA_UInt16;
    hour: UA_UInt16;
    day: UA_UInt16;
    month: UA_UInt16;
    year: UA_UInt16;
  end;

  UA_ByteString = UA_String;
  PUA_ByteString = ^UA_ByteString;

  UA_Guid = record
    data1: UA_UInt32;
    data2: UA_UInt16;
    data3: UA_UInt16;
    data4: array[0..7] of UA_Byte;
  end;

  UA_LogLevel = (
    UA_LOGLEVEL_TRACE,
    UA_LOGLEVEL_DEBUG,
    UA_LOGLEVEL_INFO,
    UA_LOGLEVEL_WARNING,
    UA_LOGLEVEL_ERROR,
    UA_LOGLEVEL_FATAL
    );

  UA_LogCategory = (
    UA_LOGCATEGORY_NETWORK,
    UA_LOGCATEGORY_SECURECHANNEL,
    UA_LOGCATEGORY_SESSION,
    UA_LOGCATEGORY_SERVER,
    UA_LOGCATEGORY_CLIENT,
    UA_LOGCATEGORY_USERLAND,
    UA_LOGCATEGORY_SECURITYPOLICY
    );

type
  UA_Logger = record
    log: procedure(logContext: Pointer;
      level: UA_LogLevel;
      category: UA_LogCategory;
      msg: PAnsiChar;
      args: Pointer
      ); cdecl;

    context: Pointer;

    clear: procedure(context: Pointer); cdecl;
  end;
  PUA_Logger = ^UA_Logger;

  UA_NodeIdType = (
    UA_NODEIDTYPE_NUMERIC = 0,
    UA_NODEIDTYPE_STRING = 3,
    UA_NODEIDTYPE_GUID = 4,
    UA_NODEIDTYPE_BYTESTRING = 5
    );

  UA_NodeId = record
    namespaceIndex: UA_UInt16;
    identifierType: UA_NodeIdType;
    identifier: record
      case longint of
        0: (numeric: UA_UInt32);
        1: (_string: UA_String);
        2: (guid: UA_Guid);
        3: (byteString: UA_ByteString);
    end;
  end;
  PUA_NodeId = ^UA_NodeId;

  UA_ExpandedNodeId = record
    nodeId: UA_NodeId;
    namespaceUri: UA_String;
    serverIndex: UA_UInt32;
  end;
  PUA_ExpandedNodeId = ^UA_ExpandedNodeId;

  UA_QualifiedName = record
    namespaceIndex: UA_UInt16;
    name: UA_String;
  end;
  PUA_QualifiedName = ^UA_QualifiedName;

  UA_LocalizedText = record
    locale: UA_String;
    text: UA_String;
  end;
  PUA_LocalizedText = ^UA_LocalizedText;

  UA_NumericRangeDimension = record
    min,
    max: UA_UInt32;
  end;

  UA_NumericRange = record
    dimensionsSize: size_t;
    dimensions: ^UA_NumericRangeDimension;
  end;
  PUA_NumericRange = ^UA_NumericRange;

  PUA_DataType = ^UA_DataType;

  UA_VariantStorageType = (
    UA_VARIANT_DATA,
    UA_VARIANT_DATA_NODELETE
    );

  UA_Variant = record
    _type: PUA_DataType;
    storageType: UA_VariantStorageType;
    arrayLength: size_t;
    data: pointer;
    arrayDimensionsSize: size_t;
    arrayDimensions: ^UA_UInt32;
  end;
  PUA_Variant = ^UA_Variant;

  UA_ExtensionObjectEncoding = (
    UA_EXTENSIONOBJECT_ENCODED_NOBODY = 0,
    UA_EXTENSIONOBJECT_ENCODED_BYTESTRING = 1,
    UA_EXTENSIONOBJECT_ENCODED_XML = 2,
    UA_EXTENSIONOBJECT_DECODED = 3,
    UA_EXTENSIONOBJECT_DECODED_NODELETE = 4
    );

  UA_ExtensionObject = record
    encoding: UA_ExtensionObjectEncoding;
    content: record
      case longint of
        0: (encoded: record
            typeId: UA_NodeId;
            body: UA_ByteString;
          end);
        1: (decoded: record
            _type: PUA_DataType;
            data: pointer;
          end);
    end;
  end;
  PUA_ExtensionObject = ^UA_ExtensionObject;

  UA_DataValue = record
    value: UA_Variant;
    sourceTimestamp: UA_DateTime;
    serverTimestamp: UA_DateTime;
    sourcePicoseconds: UA_UInt16;
    serverPicoseconds: UA_UInt16;
    status: UA_StatusCode;
    flag: UA_Byte;
  end;
  PUA_DataValue = ^UA_DataValue;

  PUA_DiagnosticInfo = ^UA_DiagnosticInfo;
  UA_DiagnosticInfo = record
    flag: UA_Boolean;
    symbolicId: UA_Int32;
    namespaceUri: UA_Int32;
    localizedText: UA_Int32;
    locale: UA_Int32;
    additionalInfo: UA_String;
    innerStatusCode: UA_StatusCode;
    innerDiagnosticInfo: PUA_DiagnosticInfo;
  end;

  UA_DataTypeMember = (*bitpacked*)record
    memberName: PAnsiChar;
    memberType: PUA_DataType;
    padding: 0..63;
    isArray: 0..1;
    isOptional: 0..1;
    fill: UA_Byte;
    fill1: UA_Byte;
    fill2: UA_Byte;
  end;

  UA_DataTypeKind = (
    UA_DATATYPEKIND_BOOLEAN = 0,
    UA_DATATYPEKIND_SBYTE = 1,
    UA_DATATYPEKIND_BYTE = 2,
    UA_DATATYPEKIND_INT16 = 3,
    UA_DATATYPEKIND_UINT16 = 4,
    UA_DATATYPEKIND_INT32 = 5,
    UA_DATATYPEKIND_UINT32 = 6,
    UA_DATATYPEKIND_INT64 = 7,
    UA_DATATYPEKIND_UINT64 = 8,
    UA_DATATYPEKIND_FLOAT = 9,
    UA_DATATYPEKIND_DOUBLE = 10,
    UA_DATATYPEKIND_STRING = 11,
    UA_DATATYPEKIND_DATETIME = 12,
    UA_DATATYPEKIND_GUID = 13,
    UA_DATATYPEKIND_BYTESTRING = 14,
    UA_DATATYPEKIND_XMLELEMENT = 15,
    UA_DATATYPEKIND_NODEID = 16,
    UA_DATATYPEKIND_EXPANDEDNODEID = 17,
    UA_DATATYPEKIND_STATUSCODE = 18,
    UA_DATATYPEKIND_QUALIFIEDNAME = 19,
    UA_DATATYPEKIND_LOCALIZEDTEXT = 20,
    UA_DATATYPEKIND_EXTENSIONOBJECT = 21,
    UA_DATATYPEKIND_DATAVALUE = 22,
    UA_DATATYPEKIND_VARIANT = 23,
    UA_DATATYPEKIND_DIAGNOSTICINFO = 24,
    UA_DATATYPEKIND_DECIMAL = 25,
    UA_DATATYPEKIND_ENUM = 26,
    UA_DATATYPEKIND_STRUCTURE = 27,
    UA_DATATYPEKIND_OPTSTRUCT = 28,
    UA_DATATYPEKIND_UNION = 29,
    UA_DATATYPEKIND_BITFIELDCLUSTER = 30
    );

  UA_DataType = (* bitpacked *)record
    typeName: PAnsiChar;
    typeId: UA_NodeId;
    binaryEncodingId: UA_NodeId;
    memSize: UA_UInt16;
    typeKind: 0..63;
    pointerFree: 0..1;
    overlayable: 0..1;
    membersSize: UA_Byte;
    members: ^UA_DataTypeMember;
  end;

  PUA_DataTypeArray = ^UA_DataTypeArray;
  UA_DataTypeArray = record
    types: PUA_DataType;
    typesSize: size_t;
  end;

const
  UA_TYPES_COUNT = 191;
  UA_TYPES_BOOLEAN = 0;
  UA_TYPES_SBYTE = 1;
  UA_TYPES_BYTE = 2;
  UA_TYPES_INT16 = 3;
  UA_TYPES_UINT16 = 4;
  UA_TYPES_INT32 = 5;
  UA_TYPES_UINT32 = 6;
  UA_TYPES_INT64 = 7;
  UA_TYPES_UINT64 = 8;
  UA_TYPES_FLOAT = 9;
  UA_TYPES_DOUBLE = 10;
  UA_TYPES_STRING = 11;
  UA_TYPES_DATETIME = 12;
  UA_TYPES_GUID = 13;
  UA_TYPES_BYTESTRING = 14;
  UA_TYPES_XMLELEMENT = 15;
  UA_TYPES_NODEID = 16;
  UA_TYPES_EXPANDEDNODEID = 17;
  UA_TYPES_STATUSCODE = 18;
  UA_TYPES_QUALIFIEDNAME = 19;
  UA_TYPES_LOCALIZEDTEXT = 20;
  UA_TYPES_EXTENSIONOBJECT = 21;
  UA_TYPES_DATAVALUE = 22;
  UA_TYPES_VARIANT = 23;
  UA_TYPES_DIAGNOSTICINFO = 24;

type
  UA_KeyValuePair = record
    key: UA_QualifiedName;
    value: UA_Variant;
  end;
  PUA_KeyValuePair = ^UA_KeyValuePair;

const
  UA_TYPES_KEYVALUEPAIR = 25;

type
  UA_NodeClass = (
    UA_NODECLASS_UNSPECIFIED = 0,
    UA_NODECLASS_OBJECT = 1,
    UA_NODECLASS_VARIABLE = 2,
    UA_NODECLASS_METHOD = 4,
    UA_NODECLASS_OBJECTTYPE = 8,
    UA_NODECLASS_VARIABLETYPE = 16,
    UA_NODECLASS_REFERENCETYPE = 32,
    UA_NODECLASS_DATATYPE = 64,
    UA_NODECLASS_VIEW = 128,
    __UA_NODECLASS_FORCE32BIT = $7FFFFFFF
    );
  PUA_NodeClass = ^UA_NodeClass;

const
  UA_TYPES_NODECLASS = 26;

type
  UA_StructureType = (
    UA_STRUCTURETYPE_STRUCTURE = 0,
    UA_STRUCTURETYPE_STRUCTUREWITHOPTIONALFIELDS = 1,
    UA_STRUCTURETYPE_UNION = 2,
    __UA_STRUCTURETYPE_FORCE32BIT = $7FFFFFFF
    );
  PUA_StructureType = ^UA_StructureType;

const
  UA_TYPES_STRUCTURETYPE = 27;

type
  UA_StructureField = record
    name: UA_String;
    description: UA_LocalizedText;
    dataType: UA_NodeId;
    valueRank: UA_Int32;
    arrayDimensionsSize: size_t;
    arrayDimensions: PUA_UInt32;
    maxStringLength: UA_UInt32;
    isOptional: UA_Boolean;
  end;
  PUA_StructureField = ^UA_StructureField;

const
  UA_TYPES_STRUCTUREFIELD = 28;

type
  UA_StructureDefinition = record
    defaultEncodingId: UA_NodeId;
    baseDataType: UA_NodeId;
    structureType: UA_StructureType;
    fieldsSize: size_t;
    fields: PUA_StructureField;
  end;
  PUA_StructureDefinition = ^UA_StructureDefinition;

const
  UA_TYPES_STRUCTUREDEFINITION = 29;

type
  UA_Argument = record
    name: UA_String;
    dataType: UA_NodeId;
    valueRank: UA_Int32;
    arrayDimensionsSize: size_t;
    arrayDimensions: PUA_UInt32;
    description: UA_LocalizedText;
  end;
  PUA_Argument = ^UA_Argument;

const
  UA_TYPES_ARGUMENT = 30;

type
  UA_EnumValueType = record
    value: UA_Int64;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
  end;
  PUA_EnumValueType = ^UA_EnumValueType;

const
  UA_TYPES_ENUMVALUETYPE = 31;

type
  UA_EnumField = record
    value: UA_Int64;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    name: UA_String;
  end;
  PUA_EnumField = ^UA_EnumField;

const
  UA_TYPES_ENUMFIELD = 32;

type
  UA_Duration = UA_Double;

const
  UA_TYPES_DURATION = 33;

type
  UA_UtcTime = UA_DateTime;

const
  UA_TYPES_UTCTIME = 34;

type
  UA_LocaleId = UA_String;

const
  UA_TYPES_LOCALEID = 35;

type
  UA_TimeZoneDataType = record
    offset: UA_Int16;
    daylightSavingInOffset: UA_Boolean;
  end;
  PUA_TimeZoneDataType = ^UA_TimeZoneDataType;

const
  UA_TYPES_TIMEZONEDATATYPE = 36;

type
  UA_ApplicationType = (
    UA_APPLICATIONTYPE_SERVER = 0,
    UA_APPLICATIONTYPE_CLIENT = 1,
    UA_APPLICATIONTYPE_CLIENTANDSERVER = 2,
    UA_APPLICATIONTYPE_DISCOVERYSERVER = 3,
    __UA_APPLICATIONTYPE_FORCE32BIT = $7FFFFFFF
    );
  PUA_ApplicationType = ^UA_ApplicationType;

const
  UA_TYPES_APPLICATIONTYPE = 37;

type
  UA_ApplicationDescription = record
    applicationUri: UA_String;
    productUri: UA_String;
    applicationName: UA_LocalizedText;
    applicationType: UA_ApplicationType;
    gatewayServerUri: UA_String;
    discoveryProfileUri: UA_String;
    discoveryUrlsSize: size_t;
    discoveryUrls: PUA_String;
  end;
  PUA_ApplicationDescription = ^UA_ApplicationDescription;

const
  UA_TYPES_APPLICATIONDESCRIPTION = 38;

type
  UA_RequestHeader = record
    authenticationToken: UA_NodeId;
    timestamp: UA_DateTime;
    requestHandle: UA_UInt32;
    returnDiagnostics: UA_UInt32;
    auditEntryId: UA_String;
    timeoutHint: UA_UInt32;
    additionalHeader: UA_ExtensionObject;
  end;
  PUA_RequestHeader = ^UA_RequestHeader;

const
  UA_TYPES_REQUESTHEADER = 39;

type
  UA_ResponseHeader = record
    timestamp: UA_DateTime;
    requestHandle: UA_UInt32;
    serviceResult: UA_StatusCode;
    serviceDiagnostics: UA_DiagnosticInfo;
    stringTableSize: size_t;
    stringTable: PUA_String;
    additionalHeader: UA_ExtensionObject;
  end;
  PUA_ResponseHeader = ^UA_ResponseHeader;

const
  UA_TYPES_RESPONSEHEADER = 40;

type
  UA_ServiceFault = record
    responseHeader: UA_ResponseHeader;
  end;
  PUA_ServiceFault = ^UA_ServiceFault;

const
  UA_TYPES_SERVICEFAULT = 41;

type
  UA_FindServersRequest = record
    requestHeader: UA_RequestHeader;
    endpointUrl: UA_String;
    localeIdsSize: size_t;
    localeIds: PUA_String;
    serverUrisSize: size_t;
    serverUris: PUA_String;
  end;
  PUA_FindServersRequest = ^UA_FindServersRequest;

const
  UA_TYPES_FINDSERVERSREQUEST = 42;

type
  UA_FindServersResponse = record
    responseHeader: UA_ResponseHeader;
    serversSize: size_t;
    servers: PUA_ApplicationDescription;
  end;
  PUA_FindServersResponse = ^UA_FindServersResponse;

const
  UA_TYPES_FINDSERVERSRESPONSE = 43;

type
  UA_MessageSecurityMode = (
    UA_MESSAGESECURITYMODE_INVALID = 0,
    UA_MESSAGESECURITYMODE_NONE = 1,
    UA_MESSAGESECURITYMODE_SIGN = 2,
    UA_MESSAGESECURITYMODE_SIGNANDENCRYPT = 3,
    __UA_MESSAGESECURITYMODE_FORCE32BIT = $7FFFFFFF
    );
  PUA_MessageSecurityMode = ^UA_MessageSecurityMode;

const
  UA_TYPES_MESSAGESECURITYMODE = 44;

type
  UA_UserTokenType = (
    UA_USERTOKENTYPE_ANONYMOUS = 0,
    UA_USERTOKENTYPE_USERNAME = 1,
    UA_USERTOKENTYPE_CERTIFICATE = 2,
    UA_USERTOKENTYPE_ISSUEDTOKEN = 3,
    __UA_USERTOKENTYPE_FORCE32BIT = $7FFFFFFF
    );
  PUA_UserTokenType = ^UA_UserTokenType;

const
  UA_TYPES_USERTOKENTYPE = 45;

type
  UA_UserTokenPolicy = record
    policyId: UA_String;
    tokenType: UA_UserTokenType;
    issuedTokenType: UA_String;
    issuerEndpointUrl: UA_String;
    securityPolicyUri: UA_String;
  end;
  PUA_UserTokenPolicy = ^UA_UserTokenPolicy;

const
  UA_TYPES_USERTOKENPOLICY = 46;

type
  UA_EndpointDescription = record
    endpointUrl: UA_String;
    server: UA_ApplicationDescription;
    securityMode: UA_MessageSecurityMode;
    securityPolicyUri: UA_String;
    userIdentityTokensSize: size_t;
    userIdentityTokens: PUA_UserTokenPolicy;
    transportProfileUri: UA_ByteString;
    securityLevel: UA_UInt32;
  end;

  PUA_EndpointDescription = ^UA_EndpointDescription;

const
  UA_TYPES_ENDPOINTDESCRIPTION = 47;

type
  UA_GetEndpointsRequest = record
    requestHeader: UA_RequestHeader;
    endpointUrl: UA_String;
    localeIdsSize: size_t;
    localeIds: PUA_String;
    profileUrisSize: size_t;
    profileUris: PUA_String;
  end;
  PUA_GetEndpointsRequest = ^UA_GetEndpointsRequest;

const
  UA_TYPES_GETENDPOINTSREQUEST = 48;

type
  UA_GetEndpointsResponse = record
    responseHeader: UA_ResponseHeader;
    endpointsSize: size_t;
    endpoints: PUA_EndpointDescription;
  end;
  PUA_GetEndpointsResponse = ^UA_GetEndpointsResponse;

const
  UA_TYPES_GETENDPOINTSRESPONSE = 49;

type
  UA_SecurityTokenRequestType = (
    UA_SECURITYTOKENREQUESTTYPE_ISSUE = 0,
    UA_SECURITYTOKENREQUESTTYPE_RENEW = 1,
    __UA_SECURITYTOKENREQUESTTYPE_FORCE32BIT = $7FFFFFFF
    );
  PUA_SecurityTokenRequestType = ^UA_SecurityTokenRequestType;

const
  UA_TYPES_SECURITYTOKENREQUESTTYPE = 50;

type
  UA_ChannelSecurityToken = record
    channelId: UA_UInt32;
    tokenId: UA_UInt32;
    createdAt: UA_DateTime;
    revisedLifetime: UA_UInt32;
  end;
  PUA_ChannelSecurityToken = ^UA_ChannelSecurityToken;

const
  UA_TYPES_CHANNELSECURITYTOKEN = 51;

type
  UA_OpenSecureChannelRequest = record
    requestHeader: UA_RequestHeader;
    clientProtocolVersion: UA_UInt32;
    requestType: UA_SecurityTokenRequestType;
    securityMode: UA_MessageSecurityMode;
    clientNonce: UA_ByteString;
    requestedLifetime: UA_UInt32;
  end;
  PUA_OpenSecureChannelRequest = ^UA_OpenSecureChannelRequest;

const
  UA_TYPES_OPENSECURECHANNELREQUEST = 52;

type
  UA_OpenSecureChannelResponse = record
    responseHeader: UA_ResponseHeader;
    serverProtocolVersion: UA_UInt32;
    securityToken: UA_ChannelSecurityToken;
    serverNonce: UA_ByteString;
  end;
  PUA_OpenSecureChannelResponse = ^UA_OpenSecureChannelResponse;

const
  UA_TYPES_OPENSECURECHANNELRESPONSE = 53;

type
  UA_CloseSecureChannelRequest = record
    requestHeader: UA_RequestHeader;
  end;
  PUA_CloseSecureChannelRequest = ^UA_CloseSecureChannelRequest;

const
  UA_TYPES_CLOSESECURECHANNELREQUEST = 54;

type
  UA_CloseSecureChannelResponse = record
    responseHeader: UA_ResponseHeader;
  end;
  PUA_CloseSecureChannelResponse = ^UA_CloseSecureChannelResponse;

const
  UA_TYPES_CLOSESECURECHANNELRESPONSE = 55;

type
  UA_SignedSoftwareCertificate = record
    certificateData: UA_ByteString;
    signature: UA_ByteString;
  end;
  PUA_SignedSoftwareCertificate = ^UA_SignedSoftwareCertificate;

const
  UA_TYPES_SIGNEDSOFTWARECERTIFICATE = 56;

type
  UA_SignatureData = record
    algorithm: UA_String;
    signature: UA_ByteString;
  end;
  PUA_SignatureData = ^UA_SignatureData;

const
  UA_TYPES_SIGNATUREDATA = 57;

type
  UA_CreateSessionRequest = record
    requestHeader: UA_RequestHeader;
    clientDescription: UA_ApplicationDescription;
    serverUri: UA_String;
    endpointUrl: UA_String;
    sessionName: UA_String;
    clientNonce: UA_ByteString;
    clientCertificate: UA_ByteString;
    requestedSessionTimeout: UA_Double;
    maxResponseMessageSize: UA_UInt32;
  end;
  PUA_CreateSessionRequest = ^UA_CreateSessionRequest;

const
  UA_TYPES_CREATESESSIONREQUEST = 58;

type
  UA_CreateSessionResponse = record
    responseHeader: UA_ResponseHeader;
    sessionId: UA_NodeId;
    authenticationToken: UA_NodeId;
    revisedSessionTimeout: UA_Double;
    serverNonce: UA_ByteString;
    serverCertificate: UA_ByteString;
    serverEndpointsSize: size_t;
    serverEndpoints: PUA_EndpointDescription;
    serverSoftwareCertificatesSize: size_t;
    serverSoftwareCertificates: PUA_SignedSoftwareCertificate;
    serverSignature: UA_SignatureData;
    maxRequestMessageSize: UA_UInt32;
  end;
  PUA_CreateSessionResponse = ^UA_CreateSessionResponse;

const
  UA_TYPES_CREATESESSIONRESPONSE = 59;

type
  UA_UserIdentityToken = record
    policyId: UA_String;
  end;
  PUA_UserIdentityToken = ^UA_UserIdentityToken;

const
  UA_TYPES_USERIDENTITYTOKEN = 60;

type
  UA_AnonymousIdentityToken = record
    policyId: UA_String;
  end;
  PUA_AnonymousIdentityToken = ^UA_AnonymousIdentityToken;

const
  UA_TYPES_ANONYMOUSIDENTITYTOKEN = 61;

type
  UA_UserNameIdentityToken = record
    policyId: UA_String;
    userName: UA_String;
    password: UA_ByteString;
    encryptionAlgorithm: UA_String;
  end;
  PUA_UserNameIdentityToken = ^UA_UserNameIdentityToken;

const
  UA_TYPES_USERNAMEIDENTITYTOKEN = 62;

type
  UA_X509IdentityToken = record
    policyId: UA_String;
    certificateData: UA_ByteString;
  end;
  PUA_X509IdentityToken = ^UA_X509IdentityToken;

const
  UA_TYPES_X509IDENTITYTOKEN = 63;

type
  UA_IssuedIdentityToken = record
    policyId: UA_String;
    tokenData: UA_ByteString;
    encryptionAlgorithm: UA_String;
  end;
  PUA_IssuedIdentityToken = ^UA_IssuedIdentityToken;

const
  UA_TYPES_ISSUEDIDENTITYTOKEN = 64;

type
  UA_ActivateSessionRequest = record
    requestHeader: UA_RequestHeader;
    clientSignature: UA_SignatureData;
    clientSoftwareCertificatesSize: size_t;
    clientSoftwareCertificates: PUA_SignedSoftwareCertificate;
    localeIdsSize: size_t;
    localeIds: PUA_String;
    userIdentityToken: UA_ExtensionObject;
    userTokenSignature: UA_SignatureData;
  end;
  PUA_ActivateSessionRequest = ^UA_ActivateSessionRequest;

const
  UA_TYPES_ACTIVATESESSIONREQUEST = 65;

type
  UA_ActivateSessionResponse = record
    responseHeader: UA_ResponseHeader;
    serverNonce: UA_ByteString;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_ActivateSessionResponse = ^UA_ActivateSessionResponse;

const
  UA_TYPES_ACTIVATESESSIONRESPONSE = 66;

type
  UA_CloseSessionRequest = record
    requestHeader: UA_RequestHeader;
    deleteSubscriptions: UA_Boolean;
  end;
  PUA_CloseSessionRequest = ^UA_CloseSessionRequest;

const
  UA_TYPES_CLOSESESSIONREQUEST = 67;

type
  UA_CloseSessionResponse = record
    responseHeader: UA_ResponseHeader;
  end;
  PUA_CloseSessionResponse = ^UA_CloseSessionResponse;

const
  UA_TYPES_CLOSESESSIONRESPONSE = 68;

type
  UA_NodeAttributesMask = (
    UA_NODEATTRIBUTESMASK_NONE = 0,
    UA_NODEATTRIBUTESMASK_ACCESSLEVEL = 1,
    UA_NODEATTRIBUTESMASK_ARRAYDIMENSIONS = 2,
    UA_NODEATTRIBUTESMASK_BROWSENAME = 4,
    UA_NODEATTRIBUTESMASK_CONTAINSNOLOOPS = 8,
    UA_NODEATTRIBUTESMASK_DATATYPE = 16,
    UA_NODEATTRIBUTESMASK_DESCRIPTION = 32,
    UA_NODEATTRIBUTESMASK_DISPLAYNAME = 64,
    UA_NODEATTRIBUTESMASK_EVENTNOTIFIER = 128,
    UA_NODEATTRIBUTESMASK_EXECUTABLE = 256,
    UA_NODEATTRIBUTESMASK_HISTORIZING = 512,
    UA_NODEATTRIBUTESMASK_INVERSENAME = 1024,
    UA_NODEATTRIBUTESMASK_ISABSTRACT = 2048,
    UA_NODEATTRIBUTESMASK_MINIMUMSAMPLINGINTERVAL = 4096,
    UA_NODEATTRIBUTESMASK_NODECLASS = 8192,
    UA_NODEATTRIBUTESMASK_NODEID = 16384,
    UA_NODEATTRIBUTESMASK_SYMMETRIC = 32768,
    UA_NODEATTRIBUTESMASK_USERACCESSLEVEL = 65536,
    UA_NODEATTRIBUTESMASK_USEREXECUTABLE = 131072,
    UA_NODEATTRIBUTESMASK_USERWRITEMASK = 262144,
    UA_NODEATTRIBUTESMASK_VALUERANK = 524288,
    UA_NODEATTRIBUTESMASK_WRITEMASK = 1048576,
    UA_NODEATTRIBUTESMASK_VALUE = 2097152,
    UA_NODEATTRIBUTESMASK_DATATYPEDEFINITION = 4194304,
    UA_NODEATTRIBUTESMASK_ROLEPERMISSIONS = 8388608,
    UA_NODEATTRIBUTESMASK_ACCESSRESTRICTIONS = 16777216,
    UA_NODEATTRIBUTESMASK_ALL = 33554431,
    UA_NODEATTRIBUTESMASK_BASENODE = 26501220,
    UA_NODEATTRIBUTESMASK_OBJECT = 26501348,
    UA_NODEATTRIBUTESMASK_OBJECTTYPE = 26503268,
    UA_NODEATTRIBUTESMASK_VARIABLE = 26571383,
    UA_NODEATTRIBUTESMASK_VARIABLETYPE = 28600438,
    UA_NODEATTRIBUTESMASK_METHOD = 26632548,
    UA_NODEATTRIBUTESMASK_REFERENCETYPE = 26537060,
    UA_NODEATTRIBUTESMASK_VIEW = 26501356,
    __UA_NODEATTRIBUTESMASK_FORCE32BIT = $7FFFFFFF
    );
  PUA_NodeAttributesMask = ^UA_NodeAttributesMask;

const
  UA_TYPES_NODEATTRIBUTESMASK = 69;

type
  UA_NodeAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
  end;
  PUA_NodeAttributes = ^UA_NodeAttributes;

const
  UA_TYPES_NODEATTRIBUTES = 70;

type
  UA_ObjectAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    eventNotifier: UA_Byte;
  end;
  PUA_ObjectAttributes = ^UA_ObjectAttributes;

const
  UA_TYPES_OBJECTATTRIBUTES = 71;

type
  UA_VariableAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    value: UA_Variant;
    dataType: UA_NodeId;
    valueRank: UA_Int32;
    arrayDimensionsSize: size_t;
    arrayDimensions: PUA_UInt32;
    accessLevel: UA_Byte;
    userAccessLevel: UA_Byte;
    minimumSamplingInterval: UA_Double;
    historizing: UA_Boolean;
  end;
  PUA_VariableAttributes = ^UA_VariableAttributes;

const
  UA_TYPES_VARIABLEATTRIBUTES = 72;

type
  UA_MethodAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    executable: UA_Boolean;
    userExecutable: UA_Boolean;
  end;
  PUA_MethodAttributes = ^UA_MethodAttributes;

const
  UA_TYPES_METHODATTRIBUTES = 73;

type
  UA_ObjectTypeAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    isAbstract: UA_Boolean;
  end;
  PUA_ObjectTypeAttributes = ^UA_ObjectTypeAttributes;

const
  UA_TYPES_OBJECTTYPEATTRIBUTES = 74;

type
  UA_VariableTypeAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    value: UA_Variant;
    dataType: UA_NodeId;
    valueRank: UA_Int32;
    arrayDimensionsSize: size_t;
    arrayDimensions: PUA_UInt32;
    isAbstract: UA_Boolean;
  end;
  PUA_VariableTypeAttributes = ^UA_VariableTypeAttributes;

const
  UA_TYPES_VARIABLETYPEATTRIBUTES = 75;

type
  UA_ReferenceTypeAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    isAbstract: UA_Boolean;
    symmetric: UA_Boolean;
    inverseName: UA_LocalizedText;
  end;
  PUA_ReferenceTypeAttributes = ^UA_ReferenceTypeAttributes;

const
  UA_TYPES_REFERENCETYPEATTRIBUTES = 76;

type
  UA_DataTypeAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    isAbstract: UA_Boolean;
  end;
  PUA_DataTypeAttributes = ^UA_DataTypeAttributes;

const
  UA_TYPES_DATATYPEATTRIBUTES = 77;

type
  UA_ViewAttributes = record
    specifiedAttributes: UA_UInt32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
    writeMask: UA_UInt32;
    userWriteMask: UA_UInt32;
    containsNoLoops: UA_Boolean;
    eventNotifier: UA_Byte;
  end;
  PUA_ViewAttributes = ^UA_ViewAttributes;

const
  UA_TYPES_VIEWATTRIBUTES = 78;

type
  UA_AddNodesItem = record
    parentNodeId: UA_ExpandedNodeId;
    referenceTypeId: UA_NodeId;
    requestedNewNodeId: UA_ExpandedNodeId;
    browseName: UA_QualifiedName;
    nodeClass: UA_NodeClass;
    nodeAttributes: UA_ExtensionObject;
    typeDefinition: UA_ExpandedNodeId;
  end;
  PUA_AddNodesItem = ^UA_AddNodesItem;

const
  UA_TYPES_ADDNODESITEM = 79;

type
  UA_AddNodesResult = record
    statusCode: UA_StatusCode;
    addedNodeId: UA_NodeId;
  end;
  PUA_AddNodesResult = ^UA_AddNodesResult;

const
  UA_TYPES_ADDNODESRESULT = 80;

type
  UA_AddNodesRequest = record
    requestHeader: UA_RequestHeader;
    nodesToAddSize: size_t;
    nodesToAdd: PUA_AddNodesItem;
  end;
  PUA_AddNodesRequest = ^UA_AddNodesRequest;

const
  UA_TYPES_ADDNODESREQUEST = 81;

type
  UA_AddNodesResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_AddNodesResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_AddNodesResponse = ^UA_AddNodesResponse;

const
  UA_TYPES_ADDNODESRESPONSE = 82;

type
  UA_AddReferencesItem = record
    sourceNodeId: UA_NodeId;
    referenceTypeId: UA_NodeId;
    isForward: UA_Boolean;
    targetServerUri: UA_String;
    targetNodeId: UA_ExpandedNodeId;
    targetNodeClass: UA_NodeClass;
  end;
  PUA_AddReferencesItem = ^UA_AddReferencesItem;

const
  UA_TYPES_ADDREFERENCESITEM = 83;

type
  UA_AddReferencesRequest = record
    requestHeader: UA_RequestHeader;
    referencesToAddSize: size_t;
    referencesToAdd: PUA_AddReferencesItem;
  end;
  PUA_AddReferencesRequest = ^UA_AddReferencesRequest;

const
  UA_TYPES_ADDREFERENCESREQUEST = 84;

type
  UA_AddReferencesResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_AddReferencesResponse = ^UA_AddReferencesResponse;

const
  UA_TYPES_ADDREFERENCESRESPONSE = 85;

type
  UA_DeleteNodesItem = record
    nodeId: UA_NodeId;
    deleteTargetReferences: UA_Boolean;
  end;
  PUA_DeleteNodesItem = ^UA_DeleteNodesItem;

const
  UA_TYPES_DELETENODESITEM = 86;

type
  UA_DeleteNodesRequest = record
    requestHeader: UA_RequestHeader;
    nodesToDeleteSize: size_t;
    nodesToDelete: PUA_DeleteNodesItem;
  end;
  PUA_DeleteNodesRequest = ^UA_DeleteNodesRequest;

const
  UA_TYPES_DELETENODESREQUEST = 87;

type
  UA_DeleteNodesResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_DeleteNodesResponse = ^UA_DeleteNodesResponse;

const
  UA_TYPES_DELETENODESRESPONSE = 88;

type
  UA_DeleteReferencesItem = record
    sourceNodeId: UA_NodeId;
    referenceTypeId: UA_NodeId;
    isForward: UA_Boolean;
    targetNodeId: UA_ExpandedNodeId;
    deleteBidirectional: UA_Boolean;
  end;
  PUA_DeleteReferencesItem = ^UA_DeleteReferencesItem;

const
  UA_TYPES_DELETEREFERENCESITEM = 89;

type
  UA_DeleteReferencesRequest = record
    requestHeader: UA_RequestHeader;
    referencesToDeleteSize: size_t;
    referencesToDelete: PUA_DeleteReferencesItem;
  end;
  PUA_DeleteReferencesRequest = ^UA_DeleteReferencesRequest;

const
  UA_TYPES_DELETEREFERENCESREQUEST = 90;

type
  UA_DeleteReferencesResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_DeleteReferencesResponse = ^UA_DeleteReferencesResponse;

const
  UA_TYPES_DELETEREFERENCESRESPONSE = 91;

type
  UA_BrowseDirection = (
    UA_BROWSEDIRECTION_FORWARD = 0,
    UA_BROWSEDIRECTION_INVERSE = 1,
    UA_BROWSEDIRECTION_BOTH = 2,
    UA_BROWSEDIRECTION_INVALID = 3,
    __UA_BROWSEDIRECTION_FORCE32BIT = $7FFFFFFF
    );
  PUA_BrowseDirection = ^UA_BrowseDirection;

const
  UA_TYPES_BROWSEDIRECTION = 92;

type
  UA_ViewDescription = record
    viewId: UA_NodeId;
    timestamp: UA_DateTime;
    viewVersion: UA_UInt32;
  end;
  PUA_ViewDescription = ^UA_ViewDescription;

const
  UA_TYPES_VIEWDESCRIPTION = 93;

type
  UA_BrowseDescription = record
    nodeId: UA_NodeId;
    browseDirection: UA_BrowseDirection;
    referenceTypeId: UA_NodeId;
    includeSubtypes: UA_Boolean;
    nodeClassMask: UA_UInt32;
    resultMask: UA_UInt32;
  end;
  PUA_BrowseDescription = ^UA_BrowseDescription;

const
  UA_TYPES_BROWSEDESCRIPTION = 94;

type
  UA_BrowseResultMask = (
    UA_BROWSERESULTMASK_NONE = 0,
    UA_BROWSERESULTMASK_REFERENCETYPEID = 1,
    UA_BROWSERESULTMASK_ISFORWARD = 2,
    UA_BROWSERESULTMASK_NODECLASS = 4,
    UA_BROWSERESULTMASK_BROWSENAME = 8,
    UA_BROWSERESULTMASK_DISPLAYNAME = 16,
    UA_BROWSERESULTMASK_TYPEDEFINITION = 32,
    UA_BROWSERESULTMASK_ALL = 63,
    UA_BROWSERESULTMASK_REFERENCETYPEINFO = 3,
    UA_BROWSERESULTMASK_TARGETINFO = 60,
    __UA_BROWSERESULTMASK_FORCE32BIT = $7FFFFFFF
    );
  PUA_BrowseResultMask = ^UA_BrowseResultMask;

const
  UA_TYPES_BROWSERESULTMASK = 95;

type
  UA_ReferenceDescription = record
    referenceTypeId: UA_NodeId;
    isForward: UA_Boolean;
    nodeId: UA_ExpandedNodeId;
    browseName: UA_QualifiedName;
    displayName: UA_LocalizedText;
    nodeClass: UA_NodeClass;
    typeDefinition: UA_ExpandedNodeId;
  end;
  PUA_ReferenceDescription = ^UA_ReferenceDescription;

const
  UA_TYPES_REFERENCEDESCRIPTION = 96;

type
  UA_BrowseResult = record
    statusCode: UA_StatusCode;
    continuationPoint: UA_ByteString;
    referencesSize: size_t;
    references: PUA_ReferenceDescription;
  end;
  PUA_BrowseResult = ^UA_BrowseResult;

const
  UA_TYPES_BROWSERESULT = 97;

type
  UA_BrowseRequest = record
    requestHeader: UA_RequestHeader;
    view: UA_ViewDescription;
    requestedMaxReferencesPerNode: UA_UInt32;
    nodesToBrowseSize: size_t;
    nodesToBrowse: PUA_BrowseDescription;
  end;
  PUA_BrowseRequest = ^UA_BrowseRequest;

const
  UA_TYPES_BROWSEREQUEST = 98;

type
  UA_BrowseResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_BrowseResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_BrowseResponse = ^UA_BrowseResponse;

const
  UA_TYPES_BROWSERESPONSE = 99;

type
  UA_BrowseNextRequest = record
    requestHeader: UA_RequestHeader;
    releaseContinuationPoints: UA_Boolean;
    continuationPointsSize: size_t;
    continuationPoints: PUA_ByteString;
  end;
  PUA_BrowseNextRequest = ^UA_BrowseNextRequest;

const
  UA_TYPES_BROWSENEXTREQUEST = 100;

type
  UA_BrowseNextResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_BrowseResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_BrowseNextResponse = ^UA_BrowseNextResponse;

const
  UA_TYPES_BROWSENEXTRESPONSE = 101;

type
  UA_RelativePathElement = record
    referenceTypeId: UA_NodeId;
    isInverse: UA_Boolean;
    includeSubtypes: UA_Boolean;
    targetName: UA_QualifiedName;
  end;
  PUA_RelativePathElement = ^UA_RelativePathElement;

const
  UA_TYPES_RELATIVEPATHELEMENT = 102;

type
  UA_RelativePath = record
    elementsSize: size_t;
    elements: PUA_RelativePathElement;
  end;
  PUA_RelativePath = ^UA_RelativePath;

const
  UA_TYPES_RELATIVEPATH = 103;

type
  UA_BrowsePath = record
    startingNode: UA_NodeId;
    relativePath: UA_RelativePath;
  end;
  PUA_BrowsePath = ^UA_BrowsePath;

const
  UA_TYPES_BROWSEPATH = 104;

type
  UA_BrowsePathTarget = record
    targetId: UA_ExpandedNodeId;
    remainingPathIndex: UA_UInt32;
  end;
  PUA_BrowsePathTarget = ^UA_BrowsePathTarget;

const
  UA_TYPES_BROWSEPATHTARGET = 105;

type
  UA_BrowsePathResult = record
    statusCode: UA_StatusCode;
    targetsSize: size_t;
    targets: PUA_BrowsePathTarget;
  end;
  PUA_BrowsePathResult = ^UA_BrowsePathResult;

const
  UA_TYPES_BROWSEPATHRESULT = 106;

type
  UA_TranslateBrowsePathsToNodeIdsRequest = record
    requestHeader: UA_RequestHeader;
    browsePathsSize: size_t;
    browsePaths: PUA_BrowsePath;
  end;
  PUA_TranslateBrowsePathsToNodeIdsRequest = ^UA_TranslateBrowsePathsToNodeIdsRequest;

const
  UA_TYPES_TRANSLATEBROWSEPATHSTONODEIDSREQUEST = 107;

type
  UA_TranslateBrowsePathsToNodeIdsResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_BrowsePathResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_TranslateBrowsePathsToNodeIdsResponse = ^UA_TranslateBrowsePathsToNodeIdsResponse;

const
  UA_TYPES_TRANSLATEBROWSEPATHSTONODEIDSRESPONSE = 108;

type
  UA_RegisterNodesRequest = record
    requestHeader: UA_RequestHeader;
    nodesToRegisterSize: size_t;
    nodesToRegister: PUA_NodeId;
  end;
  PUA_RegisterNodesRequest = ^UA_RegisterNodesRequest;

const
  UA_TYPES_REGISTERNODESREQUEST = 109;

type
  UA_RegisterNodesResponse = record
    responseHeader: UA_ResponseHeader;
    registeredNodeIdsSize: size_t;
    registeredNodeIds: PUA_NodeId;
  end;
  PUA_RegisterNodesResponse = ^UA_RegisterNodesResponse;

const
  UA_TYPES_REGISTERNODESRESPONSE = 110;

type
  UA_UnregisterNodesRequest = record
    requestHeader: UA_RequestHeader;
    nodesToUnregisterSize: size_t;
    nodesToUnregister: PUA_NodeId;
  end;
  PUA_UnregisterNodesRequest = ^UA_UnregisterNodesRequest;

const
  UA_TYPES_UNREGISTERNODESREQUEST = 111;

type
  UA_UnregisterNodesResponse = record
    responseHeader: UA_ResponseHeader;
  end;
  PUA_UnregisterNodesResponse = ^UA_UnregisterNodesResponse;

const
  UA_TYPES_UNREGISTERNODESRESPONSE = 112;

type
  UA_FilterOperator = (
    UA_FILTEROPERATOR_EQUALS = 0,
    UA_FILTEROPERATOR_ISNULL = 1,
    UA_FILTEROPERATOR_GREATERTHAN = 2,
    UA_FILTEROPERATOR_LESSTHAN = 3,
    UA_FILTEROPERATOR_GREATERTHANOREQUAL = 4,
    UA_FILTEROPERATOR_LESSTHANOREQUAL = 5,
    UA_FILTEROPERATOR_LIKE = 6,
    UA_FILTEROPERATOR_NOT = 7,
    UA_FILTEROPERATOR_BETWEEN = 8,
    UA_FILTEROPERATOR_INLIST = 9,
    UA_FILTEROPERATOR_AND = 10,
    UA_FILTEROPERATOR_OR = 11,
    UA_FILTEROPERATOR_CAST = 12,
    UA_FILTEROPERATOR_INVIEW = 13,
    UA_FILTEROPERATOR_OFTYPE = 14,
    UA_FILTEROPERATOR_RELATEDTO = 15,
    UA_FILTEROPERATOR_BITWISEAND = 16,
    UA_FILTEROPERATOR_BITWISEOR = 17,
    __UA_FILTEROPERATOR_FORCE32BIT = $7FFFFFFF
    );
  PUA_FilterOperator = ^UA_FilterOperator;

const
  UA_TYPES_FILTEROPERATOR = 113;

type
  UA_ContentFilterElement = record
    filterOperator: UA_FilterOperator;
    filterOperandsSize: size_t;
    filterOperands: PUA_ExtensionObject;
  end;
  PUA_ContentFilterElement = ^UA_ContentFilterElement;

const
  UA_TYPES_CONTENTFILTERELEMENT = 114;

type
  UA_ContentFilter = record
    elementsSize: size_t;
    elements: PUA_ContentFilterElement;
  end;
  PUA_ContentFilter = ^UA_ContentFilter;

const
  UA_TYPES_CONTENTFILTER = 115;

type
  UA_ElementOperand = record
    index: UA_UInt32;
  end;
  PUA_ElementOperand = ^UA_ElementOperand;

const
  UA_TYPES_ELEMENTOPERAND = 116;

type
  UA_LiteralOperand = record
    value: UA_Variant;
  end;
  PUA_LiteralOperand = ^UA_LiteralOperand;

const
  UA_TYPES_LITERALOPERAND = 117;

type
  UA_AttributeOperand = record
    nodeId: UA_NodeId;
    alias: UA_String;
    browsePath: UA_RelativePath;
    attributeId: UA_UInt32;
    indexRange: UA_String;
  end;
  PUA_AttributeOperand = ^UA_AttributeOperand;

const
  UA_TYPES_ATTRIBUTEOPERAND = 118;

type
  UA_SimpleAttributeOperand = record
    typeDefinitionId: UA_NodeId;
    browsePathSize: size_t;
    browsePath: PUA_QualifiedName;
    attributeId: UA_UInt32;
    indexRange: UA_String;
  end;
  PUA_SimpleAttributeOperand = ^UA_SimpleAttributeOperand;

const
  UA_TYPES_SIMPLEATTRIBUTEOPERAND = 119;

type
  UA_ContentFilterElementResult = record
    statusCode: UA_StatusCode;
    operandStatusCodesSize: size_t;
    operandStatusCodes: PUA_StatusCode;
    operandDiagnosticInfosSize: size_t;
    operandDiagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_ContentFilterElementResult = ^UA_ContentFilterElementResult;

const
  UA_TYPES_CONTENTFILTERELEMENTRESULT = 120;

type
  UA_ContentFilterResult = record
    elementResultsSize: size_t;
    elementResults: PUA_ContentFilterElementResult;
    elementDiagnosticInfosSize: size_t;
    elementDiagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_ContentFilterResult = ^UA_ContentFilterResult;

const
  UA_TYPES_CONTENTFILTERRESULT = 121;

type
  UA_TimestampsToReturn = (
    UA_TIMESTAMPSTORETURN_SOURCE = 0,
    UA_TIMESTAMPSTORETURN_SERVER = 1,
    UA_TIMESTAMPSTORETURN_BOTH = 2,
    UA_TIMESTAMPSTORETURN_NEITHER = 3,
    UA_TIMESTAMPSTORETURN_INVALID = 4,
    __UA_TIMESTAMPSTORETURN_FORCE32BIT = $7FFFFFFF
    );
  PUA_TimestampsToReturn = ^UA_TimestampsToReturn;

const
  UA_TYPES_TIMESTAMPSTORETURN = 122;

type
  UA_ReadValueId = record
    nodeId: UA_NodeId;
    attributeId: UA_UInt32;
    indexRange: UA_String;
    dataEncoding: UA_QualifiedName;
  end;
  PUA_ReadValueId = ^UA_ReadValueId;

const
  UA_TYPES_READVALUEID = 123;

type
  UA_ReadRequest = record
    requestHeader: UA_RequestHeader;
    maxAge: UA_Double;
    timestampsToReturn: UA_TimestampsToReturn;
    nodesToReadSize: size_t;
    nodesToRead: PUA_ReadValueId;
  end;
  PUA_ReadRequest = ^UA_ReadRequest;

const
  UA_TYPES_READREQUEST = 124;

type
  UA_ReadResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_DataValue;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_ReadResponse = ^UA_ReadResponse;

const
  UA_TYPES_READRESPONSE = 125;

type
  UA_WriteValue = record
    nodeId: UA_NodeId;
    attributeId: UA_UInt32;
    indexRange: UA_String;
    value: UA_DataValue;
  end;
  PUA_WriteValue = ^UA_WriteValue;

const
  UA_TYPES_WRITEVALUE = 126;

type
  UA_WriteRequest = record
    requestHeader: UA_RequestHeader;
    nodesToWriteSize: size_t;
    nodesToWrite: PUA_WriteValue;
  end;
  PUA_WriteRequest = ^UA_WriteRequest;

const
  UA_TYPES_WRITEREQUEST = 127;

type
  UA_WriteResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_WriteResponse = ^UA_WriteResponse;

const
  UA_TYPES_WRITERESPONSE = 128;

type
  UA_CallMethodRequest = record
    objectId: UA_NodeId;
    methodId: UA_NodeId;
    inputArgumentsSize: size_t;
    inputArguments: PUA_Variant;
  end;
  PUA_CallMethodRequest = ^UA_CallMethodRequest;

const
  UA_TYPES_CALLMETHODREQUEST = 129;

type
  UA_CallMethodResult = record
    statusCode: UA_StatusCode;
    inputArgumentResultsSize: size_t;
    inputArgumentResults: PUA_StatusCode;
    inputArgumentDiagnosticInfosSize: size_t;
    inputArgumentDiagnosticInfos: PUA_DiagnosticInfo;
    outputArgumentsSize: size_t;
    outputArguments: PUA_Variant;
  end;
  PUA_CallMethodResult = ^UA_CallMethodResult;

const
  UA_TYPES_CALLMETHODRESULT = 130;

type
  UA_CallRequest = record
    requestHeader: UA_RequestHeader;
    methodsToCallSize: size_t;
    methodsToCall: PUA_CallMethodRequest;
  end;
  PUA_CallRequest = ^UA_CallRequest;

const
  UA_TYPES_CALLREQUEST = 131;

type
  UA_CallResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_CallMethodResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_CallResponse = ^UA_CallResponse;

const
  UA_TYPES_CALLRESPONSE = 132;

type
  UA_MonitoringMode = (
    UA_MONITORINGMODE_DISABLED = 0,
    UA_MONITORINGMODE_SAMPLING = 1,
    UA_MONITORINGMODE_REPORTING = 2,
    __UA_MONITORINGMODE_FORCE32BIT = $7FFFFFFF
    );
  PUA_MonitoringMode = ^UA_MonitoringMode;

const
  UA_TYPES_MONITORINGMODE = 133;

type
  UA_DataChangeTrigger = (
    UA_DATACHANGETRIGGER_STATUS = 0,
    UA_DATACHANGETRIGGER_STATUSVALUE = 1,
    UA_DATACHANGETRIGGER_STATUSVALUETIMESTAMP = 2,
    __UA_DATACHANGETRIGGER_FORCE32BIT = $7FFFFFFF
    );
  PUA_DataChangeTrigger = ^UA_DataChangeTrigger;

const
  UA_TYPES_DATACHANGETRIGGER = 134;

type
  UA_DeadbandType = (
    UA_DEADBANDTYPE_NONE = 0,
    UA_DEADBANDTYPE_ABSOLUTE = 1,
    UA_DEADBANDTYPE_PERCENT = 2,
    __UA_DEADBANDTYPE_FORCE32BIT = $7FFFFFFF
    );
  PUA_DeadbandType = ^UA_DeadbandType;

const
  UA_TYPES_DEADBANDTYPE = 135;

type
  UA_DataChangeFilter = record
    trigger: UA_DataChangeTrigger;
    deadbandType: UA_UInt32;
    deadbandValue: UA_Double;
  end;
  PUA_DataChangeFilter = ^UA_DataChangeFilter;

const
  UA_TYPES_DATACHANGEFILTER = 136;

type
  UA_EventFilter = record
    selectClausesSize: size_t;
    selectClauses: PUA_SimpleAttributeOperand;
    whereClause: UA_ContentFilter;
  end;
  PUA_EventFilter = ^UA_EventFilter;

const
  UA_TYPES_EVENTFILTER = 137;

type
  UA_AggregateConfiguration = record
    useServerCapabilitiesDefaults: UA_Boolean;
    treatUncertainAsBad: UA_Boolean;
    percentDataBad: UA_Byte;
    percentDataGood: UA_Byte;
    useSlopedExtrapolation: UA_Boolean;
  end;
  PUA_AggregateConfiguration = ^UA_AggregateConfiguration;

const
  UA_TYPES_AGGREGATECONFIGURATION = 138;

type
  UA_AggregateFilter = record
    startTime: UA_DateTime;
    aggregateType: UA_NodeId;
    processingInterval: UA_Double;
    aggregateConfiguration: UA_AggregateConfiguration;
  end;
  PUA_AggregateFilter = ^UA_AggregateFilter;

const
  UA_TYPES_AGGREGATEFILTER = 139;

type
  UA_EventFilterResult = record
    selectClauseResultsSize: size_t;
    selectClauseResults: PUA_StatusCode;
    selectClauseDiagnosticInfosSize: size_t;
    selectClauseDiagnosticInfos: PUA_DiagnosticInfo;
    whereClauseResult: UA_ContentFilterResult;
  end;
  PUA_EventFilterResult = ^UA_EventFilterResult;

const
  UA_TYPES_EVENTFILTERRESULT = 140;

type
  UA_MonitoringParameters = record
    clientHandle: UA_UInt32;
    samplingInterval: UA_Double;
    filter: UA_ExtensionObject;
    queueSize: UA_UInt32;
    discardOldest: UA_Boolean;
  end;
  PUA_MonitoringParameters = ^UA_MonitoringParameters;

const
  UA_TYPES_MONITORINGPARAMETERS = 141;

type
  UA_MonitoredItemCreateRequest = record
    itemToMonitor: UA_ReadValueId;
    monitoringMode: UA_MonitoringMode;
    requestedParameters: UA_MonitoringParameters;
  end;
  PUA_MonitoredItemCreateRequest = ^UA_MonitoredItemCreateRequest;

const
  UA_TYPES_MONITOREDITEMCREATEREQUEST = 142;

type
  UA_MonitoredItemCreateResult = record
    statusCode: UA_StatusCode;
    monitoredItemId: UA_UInt32;
    revisedSamplingInterval: UA_Double;
    revisedQueueSize: UA_UInt32;
    filterResult: UA_ExtensionObject;
  end;
  PUA_MonitoredItemCreateResult = ^UA_MonitoredItemCreateResult;

const
  UA_TYPES_MONITOREDITEMCREATERESULT = 143;

type
  UA_CreateMonitoredItemsRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionId: UA_UInt32;
    timestampsToReturn: UA_TimestampsToReturn;
    itemsToCreateSize: size_t;
    itemsToCreate: PUA_MonitoredItemCreateRequest;
  end;
  PUA_CreateMonitoredItemsRequest = ^UA_CreateMonitoredItemsRequest;

const
  UA_TYPES_CREATEMONITOREDITEMSREQUEST = 144;

type
  UA_CreateMonitoredItemsResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_MonitoredItemCreateResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_CreateMonitoredItemsResponse = ^UA_CreateMonitoredItemsResponse;

const
  UA_TYPES_CREATEMONITOREDITEMSRESPONSE = 145;

type
  UA_MonitoredItemModifyRequest = record
    monitoredItemId: UA_UInt32;
    requestedParameters: UA_MonitoringParameters;
  end;
  PUA_MonitoredItemModifyRequest = ^UA_MonitoredItemModifyRequest;

const
  UA_TYPES_MONITOREDITEMMODIFYREQUEST = 146;

type
  UA_MonitoredItemModifyResult = record
    statusCode: UA_StatusCode;
    revisedSamplingInterval: UA_Double;
    revisedQueueSize: UA_UInt32;
    filterResult: UA_ExtensionObject;
  end;
  PUA_MonitoredItemModifyResult = ^UA_MonitoredItemModifyResult;

const
  UA_TYPES_MONITOREDITEMMODIFYRESULT = 147;

type
  UA_ModifyMonitoredItemsRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionId: UA_UInt32;
    timestampsToReturn: UA_TimestampsToReturn;
    itemsToModifySize: size_t;
    itemsToModify: PUA_MonitoredItemModifyRequest;
  end;
  PUA_ModifyMonitoredItemsRequest = ^UA_ModifyMonitoredItemsRequest;

const
  UA_TYPES_MODIFYMONITOREDITEMSREQUEST = 148;

type
  UA_ModifyMonitoredItemsResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_MonitoredItemModifyResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_ModifyMonitoredItemsResponse = ^UA_ModifyMonitoredItemsResponse;

const
  UA_TYPES_MODIFYMONITOREDITEMSRESPONSE = 149;

type
  UA_SetMonitoringModeRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionId: UA_UInt32;
    monitoringMode: UA_MonitoringMode;
    monitoredItemIdsSize: size_t;
    monitoredItemIds: PUA_UInt32;
  end;
  PUA_SetMonitoringModeRequest = ^UA_SetMonitoringModeRequest;

const
  UA_TYPES_SETMONITORINGMODEREQUEST = 150;

type
  UA_SetMonitoringModeResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_SetMonitoringModeResponse = ^UA_SetMonitoringModeResponse;

const
  UA_TYPES_SETMONITORINGMODERESPONSE = 151;

type
  UA_SetTriggeringRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionId: UA_UInt32;
    triggeringItemId: UA_UInt32;
    linksToAddSize: size_t;
    linksToAdd: PUA_UInt32;
    linksToRemoveSize: size_t;
    linksToRemove: PUA_UInt32;
  end;
  PUA_SetTriggeringRequest = ^UA_SetTriggeringRequest;

const
  UA_TYPES_SETTRIGGERINGREQUEST = 152;

type
  UA_SetTriggeringResponse = record
    responseHeader: UA_ResponseHeader;
    addResultsSize: size_t;
    addResults: PUA_StatusCode;
    addDiagnosticInfosSize: size_t;
    addDiagnosticInfos: PUA_DiagnosticInfo;
    removeResultsSize: size_t;
    removeResults: PUA_StatusCode;
    removeDiagnosticInfosSize: size_t;
    removeDiagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_SetTriggeringResponse = ^UA_SetTriggeringResponse;

const
  UA_TYPES_SETTRIGGERINGRESPONSE = 153;

type
  UA_DeleteMonitoredItemsRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionId: UA_UInt32;
    monitoredItemIdsSize: size_t;
    monitoredItemIds: PUA_UInt32;
  end;
  PUA_DeleteMonitoredItemsRequest = ^UA_DeleteMonitoredItemsRequest;

const
  UA_TYPES_DELETEMONITOREDITEMSREQUEST = 154;

type
  UA_DeleteMonitoredItemsResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_DeleteMonitoredItemsResponse = ^UA_DeleteMonitoredItemsResponse;

const
  UA_TYPES_DELETEMONITOREDITEMSRESPONSE = 155;

type
  UA_CreateSubscriptionRequest = record
    requestHeader: UA_RequestHeader;
    requestedPublishingInterval: UA_Double;
    requestedLifetimeCount: UA_UInt32;
    requestedMaxKeepAliveCount: UA_UInt32;
    maxNotificationsPerPublish: UA_UInt32;
    publishingEnabled: UA_Boolean;
    priority: UA_Byte;
  end;
  PUA_CreateSubscriptionRequest = ^UA_CreateSubscriptionRequest;

const
  UA_TYPES_CREATESUBSCRIPTIONREQUEST = 156;

type
  UA_CreateSubscriptionResponse = record
    responseHeader: UA_ResponseHeader;
    subscriptionId: UA_UInt32;
    revisedPublishingInterval: UA_Double;
    revisedLifetimeCount: UA_UInt32;
    revisedMaxKeepAliveCount: UA_UInt32;
  end;
  PUA_CreateSubscriptionResponse = ^UA_CreateSubscriptionResponse;

const
  UA_TYPES_CREATESUBSCRIPTIONRESPONSE = 157;

type
  UA_ModifySubscriptionRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionId: UA_UInt32;
    requestedPublishingInterval: UA_Double;
    requestedLifetimeCount: UA_UInt32;
    requestedMaxKeepAliveCount: UA_UInt32;
    maxNotificationsPerPublish: UA_UInt32;
    priority: UA_Byte;
  end;
  PUA_ModifySubscriptionRequest = ^UA_ModifySubscriptionRequest;

const
  UA_TYPES_MODIFYSUBSCRIPTIONREQUEST = 158;

type
  UA_ModifySubscriptionResponse = record
    responseHeader: UA_ResponseHeader;
    revisedPublishingInterval: UA_Double;
    revisedLifetimeCount: UA_UInt32;
    revisedMaxKeepAliveCount: UA_UInt32;
  end;
  PUA_ModifySubscriptionResponse = ^UA_ModifySubscriptionResponse;

const
  UA_TYPES_MODIFYSUBSCRIPTIONRESPONSE = 159;

type
  UA_SetPublishingModeRequest = record
    requestHeader: UA_RequestHeader;
    publishingEnabled: UA_Boolean;
    subscriptionIdsSize: size_t;
    subscriptionIds: PUA_UInt32;
  end;
  PUA_SetPublishingModeRequest = ^UA_SetPublishingModeRequest;

const
  UA_TYPES_SETPUBLISHINGMODEREQUEST = 160;

type
  UA_SetPublishingModeResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_SetPublishingModeResponse = ^UA_SetPublishingModeResponse;

const
  UA_TYPES_SETPUBLISHINGMODERESPONSE = 161;

type
  UA_NotificationMessage = record
    sequenceNumber: UA_UInt32;
    publishTime: UA_DateTime;
    notificationDataSize: size_t;
    notificationData: PUA_ExtensionObject;
  end;
  PUA_NotificationMessage = ^UA_NotificationMessage;

const
  UA_TYPES_NOTIFICATIONMESSAGE = 162;

type
  UA_MonitoredItemNotification = record
    clientHandle: UA_UInt32;
    value: UA_DataValue;
  end;
  PUA_MonitoredItemNotification = ^UA_MonitoredItemNotification;

const
  UA_TYPES_MONITOREDITEMNOTIFICATION = 163;

type
  UA_EventFieldList = record
    clientHandle: UA_UInt32;
    eventFieldsSize: size_t;
    eventFields: PUA_Variant;
  end;
  PUA_EventFieldList = ^UA_EventFieldList;

const
  UA_TYPES_EVENTFIELDLIST = 164;

type
  UA_StatusChangeNotification = record
    status: UA_StatusCode;
    diagnosticInfo: UA_DiagnosticInfo;
  end;
  PUA_StatusChangeNotification = ^UA_StatusChangeNotification;

const
  UA_TYPES_STATUSCHANGENOTIFICATION = 165;

type
  UA_SubscriptionAcknowledgement = record
    subscriptionId: UA_UInt32;
    sequenceNumber: UA_UInt32;
  end;
  PUA_SubscriptionAcknowledgement = ^UA_SubscriptionAcknowledgement;

const
  UA_TYPES_SUBSCRIPTIONACKNOWLEDGEMENT = 166;

type
  UA_PublishRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionAcknowledgementsSize: size_t;
    subscriptionAcknowledgements: PUA_SubscriptionAcknowledgement;
  end;
  PUA_PublishRequest = ^UA_PublishRequest;

const
  UA_TYPES_PUBLISHREQUEST = 167;

type
  UA_PublishResponse = record
    responseHeader: UA_ResponseHeader;
    subscriptionId: UA_UInt32;
    availableSequenceNumbersSize: size_t;
    availableSequenceNumbers: PUA_UInt32;
    moreNotifications: UA_Boolean;
    notificationMessage: UA_NotificationMessage;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_PublishResponse = ^UA_PublishResponse;

const
  UA_TYPES_PUBLISHRESPONSE = 168;

type
  UA_RepublishRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionId: UA_UInt32;
    retransmitSequenceNumber: UA_UInt32;
  end;
  PUA_RepublishRequest = ^UA_RepublishRequest;

const
  UA_TYPES_REPUBLISHREQUEST = 169;

type
  UA_RepublishResponse = record
    responseHeader: UA_ResponseHeader;
    notificationMessage: UA_NotificationMessage;
  end;
  PUA_RepublishResponse = ^UA_RepublishResponse;

const
  UA_TYPES_REPUBLISHRESPONSE = 170;

type
  UA_TransferResult = record
    statusCode: UA_StatusCode;
    availableSequenceNumbersSize: size_t;
    availableSequenceNumbers: PUA_UInt32;
  end;
  PUA_TransferResult = ^UA_TransferResult;

const
  UA_TYPES_TRANSFERRESULT = 171;

type
  UA_TransferSubscriptionsRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionIdsSize: size_t;
    subscriptionIds: PUA_UInt32;
    sendInitialValues: UA_Boolean;
  end;
  PUA_TransferSubscriptionsRequest = ^UA_TransferSubscriptionsRequest;

const
  UA_TYPES_TRANSFERSUBSCRIPTIONSREQUEST = 172;

type
  UA_TransferSubscriptionsResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_TransferResult;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_TransferSubscriptionsResponse = ^UA_TransferSubscriptionsResponse;

const
  UA_TYPES_TRANSFERSUBSCRIPTIONSRESPONSE = 173;

type
  UA_DeleteSubscriptionsRequest = record
    requestHeader: UA_RequestHeader;
    subscriptionIdsSize: size_t;
    subscriptionIds: PUA_UInt32;
  end;
  PUA_DeleteSubscriptionsRequest = ^UA_DeleteSubscriptionsRequest;

const
  UA_TYPES_DELETESUBSCRIPTIONSREQUEST = 174;

type
  UA_DeleteSubscriptionsResponse = record
    responseHeader: UA_ResponseHeader;
    resultsSize: size_t;
    results: PUA_StatusCode;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_DeleteSubscriptionsResponse = ^UA_DeleteSubscriptionsResponse;

const
  UA_TYPES_DELETESUBSCRIPTIONSRESPONSE = 175;

type
  UA_BuildInfo = record
    productUri: UA_String;
    manufacturerName: UA_String;
    productName: UA_String;
    softwareVersion: UA_String;
    buildNumber: UA_String;
    buildDate: UA_DateTime;
  end;
  PUA_BuildInfo = ^UA_BuildInfo;

const
  UA_TYPES_BUILDINFO = 176;

type
  UA_RedundancySupport = (
    UA_REDUNDANCYSUPPORT_NONE = 0,
    UA_REDUNDANCYSUPPORT_COLD = 1,
    UA_REDUNDANCYSUPPORT_WARM = 2,
    UA_REDUNDANCYSUPPORT_HOT = 3,
    UA_REDUNDANCYSUPPORT_TRANSPARENT = 4,
    UA_REDUNDANCYSUPPORT_HOTANDMIRRORED = 5,
    __UA_REDUNDANCYSUPPORT_FORCE32BIT = $7FFFFFFF
    );
  PUA_RedundancySupport = ^UA_RedundancySupport;

const
  UA_TYPES_REDUNDANCYSUPPORT = 177;

type
  UA_ServerState = (
    UA_SERVERSTATE_RUNNING = 0,
    UA_SERVERSTATE_FAILED = 1,
    UA_SERVERSTATE_NOCONFIGURATION = 2,
    UA_SERVERSTATE_SUSPENDED = 3,
    UA_SERVERSTATE_SHUTDOWN = 4,
    UA_SERVERSTATE_TEST = 5,
    UA_SERVERSTATE_COMMUNICATIONFAULT = 6,
    UA_SERVERSTATE_UNKNOWN = 7,
    __UA_SERVERSTATE_FORCE32BIT = $7FFFFFFF
    );
  PUA_ServerState = ^UA_ServerState;

const
  UA_TYPES_SERVERSTATE = 178;

type
  UA_ServerDiagnosticsSummaryDataType = record
    serverViewCount: UA_UInt32;
    currentSessionCount: UA_UInt32;
    cumulatedSessionCount: UA_UInt32;
    securityRejectedSessionCount: UA_UInt32;
    rejectedSessionCount: UA_UInt32;
    sessionTimeoutCount: UA_UInt32;
    sessionAbortCount: UA_UInt32;
    currentSubscriptionCount: UA_UInt32;
    cumulatedSubscriptionCount: UA_UInt32;
    publishingIntervalCount: UA_UInt32;
    securityRejectedRequestsCount: UA_UInt32;
    rejectedRequestsCount: UA_UInt32;
  end;
  PUA_ServerDiagnosticsSummaryDataType = ^UA_ServerDiagnosticsSummaryDataType;

const
  UA_TYPES_SERVERDIAGNOSTICSSUMMARYDATATYPE = 179;

type
  UA_ServerStatusDataType = record
    startTime: UA_DateTime;
    currentTime: UA_DateTime;
    state: UA_ServerState;
    buildInfo: UA_BuildInfo;
    secondsTillShutdown: UA_UInt32;
    shutdownReason: UA_LocalizedText;
  end;
  PUA_ServerStatusDataType = ^UA_ServerStatusDataType;

const
  UA_TYPES_SERVERSTATUSDATATYPE = 180;

type
  UA_Range = record
    low: UA_Double;
    high: UA_Double;
  end;
  PUA_Range = ^UA_Range;

const
  UA_TYPES_RANGE = 181;

type
  UA_EUInformation = record
    namespaceUri: UA_String;
    unitId: UA_Int32;
    displayName: UA_LocalizedText;
    description: UA_LocalizedText;
  end;
  PUA_EUInformation = ^UA_EUInformation;

const
  UA_TYPES_EUINFORMATION = 182;

type
  UA_AxisScaleEnumeration = (
    UA_AXISSCALEENUMERATION_LINEAR = 0,
    UA_AXISSCALEENUMERATION_LOG = 1,
    UA_AXISSCALEENUMERATION_LN = 2,
    __UA_AXISSCALEENUMERATION_FORCE32BIT = $7FFFFFFF
    );
  PUA_AxisScaleEnumeration = ^UA_AxisScaleEnumeration;

const
  UA_TYPES_AXISSCALEENUMERATION = 183;

type
  UA_ComplexNumberType = record
    real: UA_Float;
    imaginary: UA_Float;
  end;
  PUA_ComplexNumberType = ^UA_ComplexNumberType;

const
  UA_TYPES_COMPLEXNUMBERTYPE = 184;

type
  UA_DoubleComplexNumberType = record
    real: UA_Double;
    imaginary: UA_Double;
  end;
  PUA_DoubleComplexNumberType = ^UA_DoubleComplexNumberType;

const
  UA_TYPES_DOUBLECOMPLEXNUMBERTYPE = 185;

type
  UA_AxisInformation = record
    engineeringUnits: UA_EUInformation;
    eURange: UA_Range;
    title: UA_LocalizedText;
    axisScaleType: UA_AxisScaleEnumeration;
    axisStepsSize: size_t;
    axisSteps: PUA_Double;
  end;
  PUA_AxisInformation = ^UA_AxisInformation;

const
  UA_TYPES_AXISINFORMATION = 186;

type
  UA_XVType = record
    x: UA_Double;
    value: UA_Float;
  end;
  PUA_XVType = ^UA_XVType;

const
  UA_TYPES_XVTYPE = 187;

type
  UA_EnumDefinition = record
    fieldsSize: size_t;
    fields: PUA_EnumField;
  end;
  PUA_EnumDefinition = ^UA_EnumDefinition;

const
  UA_TYPES_ENUMDEFINITION = 188;

type
  UA_DataChangeNotification = record
    monitoredItemsSize: size_t;
    monitoredItems: PUA_MonitoredItemNotification;
    diagnosticInfosSize: size_t;
    diagnosticInfos: PUA_DiagnosticInfo;
  end;
  PUA_DataChangeNotification = ^UA_DataChangeNotification;

const
  UA_TYPES_DATACHANGENOTIFICATION = 189;

type
  UA_EventNotificationList = record
    eventsSize: size_t;
    events: PUA_EventFieldList;
  end;
  PUA_EventNotificationList = ^UA_EventNotificationList;

const
  UA_TYPES_EVENTNOTIFICATIONLIST = 190;

type
  UA_AttributeId = (
    UA_ATTRIBUTEID_NODEID = 1,
    UA_ATTRIBUTEID_NODECLASS = 2,
    UA_ATTRIBUTEID_BROWSENAME = 3,
    UA_ATTRIBUTEID_DISPLAYNAME = 4,
    UA_ATTRIBUTEID_DESCRIPTION = 5,
    UA_ATTRIBUTEID_WRITEMASK = 6,
    UA_ATTRIBUTEID_USERWRITEMASK = 7,
    UA_ATTRIBUTEID_ISABSTRACT = 8,
    UA_ATTRIBUTEID_SYMMETRIC = 9,
    UA_ATTRIBUTEID_INVERSENAME = 10,
    UA_ATTRIBUTEID_CONTAINSNOLOOPS = 11,
    UA_ATTRIBUTEID_EVENTNOTIFIER = 12,
    UA_ATTRIBUTEID_VALUE = 13,
    UA_ATTRIBUTEID_DATATYPE = 14,
    UA_ATTRIBUTEID_VALUERANK = 15,
    UA_ATTRIBUTEID_ARRAYDIMENSIONS = 16,
    UA_ATTRIBUTEID_ACCESSLEVEL = 17,
    UA_ATTRIBUTEID_USERACCESSLEVEL = 18,
    UA_ATTRIBUTEID_MINIMUMSAMPLINGINTERVAL = 19,
    UA_ATTRIBUTEID_HISTORIZING = 20,
    UA_ATTRIBUTEID_EXECUTABLE = 21,
    UA_ATTRIBUTEID_USEREXECUTABLE = 22,
    UA_ATTRIBUTEID_DATATYPEDEFINITION = 23
    );

  UA_RuleHandling = (
    UA_RULEHANDLING_DEFAULT = 0,
    UA_RULEHANDLING_ABORT,
    UA_RULEHANDLING_WARN,
    UA_RULEHANDLING_ACCEPT
    );

  UA_SecureChannelState = (
    UA_SECURECHANNELSTATE_CLOSED,
    UA_SECURECHANNELSTATE_HEL_SENT,
    UA_SECURECHANNELSTATE_HEL_RECEIVED,
    UA_SECURECHANNELSTATE_ACK_SENT,
    UA_SECURECHANNELSTATE_ACK_RECEIVED,
    UA_SECURECHANNELSTATE_OPN_SENT,
    UA_SECURECHANNELSTATE_OPEN,
    UA_SECURECHANNELSTATE_CLOSING
    );
  PUA_SecureChannelState = ^UA_SecureChannelState;

  UA_SessionState = (
    UA_SESSIONSTATE_CLOSED,
    UA_SESSIONSTATE_CREATE_REQUESTED,
    UA_SESSIONSTATE_CREATED,
    UA_SESSIONSTATE_ACTIVATE_REQUESTED,
    UA_SESSIONSTATE_ACTIVATED,
    UA_SESSIONSTATE_CLOSING
    );
  PUA_SessionState = ^UA_SessionState;

  UA_NetworkStatistics = record
    currentConnectionCount: size_t;
    cumulatedConnectionCount: size_t;
    rejectedConnectionCount: size_t;
    connectionTimeoutCount: size_t;
    connectionAbortCount: size_t;
  end;
  PUA_NetworkStatistics = ^UA_NetworkStatistics;

  UA_SecureChannelStatistics = record
    currentChannelCount: size_t;
    cumulatedChannelCount: size_t;
    rejectedChannelCount: size_t;
    channelTimeoutCount: size_t;
    channelAbortCount: size_t;
    channelPurgeCount: size_t;
  end;
  PUA_SecureChannelStatistics = ^UA_SecureChannelStatistics;

  UA_SessionStatistics = record
    currentSessionCount: size_t;
    cumulatedSessionCount: size_t;
    securityRejectedSessionCount: size_t;
    rejectedSessionCount: size_t;
    sessionTimeoutCount: size_t;
    sessionAbortCount: size_t;
  end;
  PUA_SessionStatistics = ^UA_SessionStatistics;

  UA_ConnectionConfig = record
    protocolVersion: UA_UInt32;
    sendBufferSize: UA_UInt32;
    recvBufferSize: UA_UInt32;
    maxMessageSize: UA_UInt32;
    maxChunkCount: UA_UInt32;
  end;
  PUA_ConnectionConfig = ^UA_ConnectionConfig;

  UA_ConnectionState = (UA_CONNECTION_CLOSED, UA_CONNECTION_OPENING, UA_CONNECTION_ESTABLISHED);

  UA_SecureChannel = record
  end;

  UA_SOCKET = Integer;

  PUA_Connection = ^UA_Connection;
  UA_Connection = record
    state: UA_ConnectionState;
    config: UA_ConnectionConfig;
    channel: ^UA_SecureChannel;
    sockfd: UA_SOCKET;
    openingDate: UA_DateTime;
    handle: pointer;
    incompleteChunk: UA_ByteString;
    connectCallbackID: UA_UInt64;
    getSendBuffer: function(connection: PUA_Connection; length: size_t; buf: PUA_ByteString): UA_StatusCode; cdecl;
    releaseSendBuffer: procedure(connection: PUA_Connection; buf: PUA_ByteString); cdecl;
    send: function(connection: PUA_Connection; buf: PUA_ByteString): UA_StatusCode; cdecl;
    recv: function(connection: PUA_Connection; response: PUA_ByteString; timeout: UA_UInt32): UA_StatusCode; cdecl;
    releaseRecvBuffer: procedure(connection: PUA_Connection; buf: PUA_ByteString); cdecl;
    close: procedure(connection: PUA_Connection); cdecl;
    free: procedure(connection: PUA_Connection); cdecl;
  end;

  UA_ConnectClientConnection = function(config: UA_ConnectionConfig; endpointUrl: UA_String; timeout: UA_UInt32; logger: PUA_Logger): UA_Connection; cdecl;

  PUA_ServerNetworkLayer = ^UA_ServerNetworkLayer;
  PUA_Server = ^UA_Server;
  UA_ServerNetworkLayer = record
    handle: pointer;
    statistics: PUA_NetworkStatistics;
    discoveryUrl: UA_String;
    localConnectionConfig: UA_ConnectionConfig;
    start: function(nl: PUA_ServerNetworkLayer; const logger: PUA_Logger; const customHostname: PUA_String): UA_StatusCode; cdecl;
    listen: function(nl: PUA_ServerNetworkLayer; server: PUA_Server; timeout: UA_UInt16): UA_StatusCode; cdecl;
    stop: procedure(nl: PUA_ServerNetworkLayer; server: PUA_Server); cdecl;
    clear: procedure(nl: PUA_ServerNetworkLayer); cdecl;
  end;

  PUA_SecurityPolicy = ^UA_SecurityPolicy;
  UA_SecurityPolicy = record
    policyUri: UA_String;
    asymmetricModule: Pointer;
    symmetricModule: Pointer;
    certificateModule: Pointer;
    policyContext: Pointer;
  end;

  PUA_CertificateVerification = ^UA_CertificateVerification;
  UA_CertificateVerification = record
    verifyCertificate: function(verificationContext: Pointer; certificate: PUA_ByteString): UA_StatusCode; cdecl;
    clear: procedure(verificationContext: Pointer); cdecl;
    verificationContext: Pointer;
  end;

  PUA_EventLoop = ^UA_EventLoop;
  UA_EventLoop = record
    dummy: Pointer;
  end;

  PUA_ClientConfig = ^UA_ClientConfig;
  UA_ClientConfig = record
    clientContext: Pointer;
    logging: PUA_Logger;

    timeout: UA_UInt32;
    clientDescription: UA_ApplicationDescription;

    endpointUrl: UA_String;

    userIdentityToken: UA_ExtensionObject;
    securityMode: UA_MessageSecurityMode;
    securityPolicyUri: UA_String;

    noSession: UA_Boolean;
    noReconnect: UA_Boolean;
    noNewSession: UA_Boolean;

    endpoint: UA_EndpointDescription;
    userTokenPolicy: UA_UserTokenPolicy;

    applicationUri: UA_String;

    customDataTypes: PUA_DataTypeArray;

    secureChannelLifeTime: UA_UInt32;
    requestedSessionTimeout: UA_UInt32;
    localConnectionConfig: UA_ConnectionConfig;
    connectivityCheckInterval: UA_UInt32;

    eventLoop: PUA_EventLoop;
    externalEventLoop: UA_Boolean;

    securityPoliciesSize: UA_UInt32;
    securityPolicies: PUA_SecurityPolicy;

    certificateVerification: UA_CertificateVerification;

    authSecurityPoliciesSize: UA_UInt32;
    authSecurityPolicies: PUA_SecurityPolicy;

    authSecurityPolicyUri: UA_String;

    stateCallback: procedure(client: PUA_Client;
      channelState: UA_SecureChannelState;
      sessionState: UA_SessionState;
      connectStatus: UA_StatusCode); cdecl;

    inactivityCallback: procedure(client: PUA_Client); cdecl;

    outStandingPublishRequests: UA_UInt16;

    subscriptionInactivityCallback: procedure(client: PUA_Client;
      subscriptionId: UA_UInt32;
      subContext: Pointer); cdecl;

    sessionName: UA_String;
    sessionLocaleIds: PUA_LocaleId;
    sessionLocaleIdsSize: UA_UInt32;
    // privateKeyPasswordCallback: function(config: PUA_ClientConfig; password: PUA_ByteString): UA_StatusCode; cdecl;
  end;

  UA_Client_DeleteSubscriptionCallback = procedure(client: PUA_Client; subId: UA_UInt32; subContext: Pointer); cdecl;
  UA_Client_StatusChangeNotificationCallback = procedure(client: PUA_Client; subId: UA_UInt32; subContext: Pointer; notification: PUA_StatusChangeNotification); cdecl;
  UA_Client_DeleteMonitoredItemCallback = procedure(client: PUA_Client; subId: UA_UInt32; subContext: Pointer; monId: UA_UInt32; monContext: Pointer); cdecl;
  UA_Client_DataChangeNotificationCallback = procedure(client: PUA_Client; subId: UA_UInt32; subContext: Pointer; monId: UA_UInt32; monContext: Pointer; value: PUA_DataValue); cdecl;
  UA_Client_EventNotificationCallback = procedure(client: PUA_Client; subId: UA_UInt32; subContext: Pointer; monId: UA_UInt32; monContext: Pointer; nEventFields: size_t; eventFields: PUA_Variant); cdecl;

  UA_Server = record
  end;

  UA_MethodCallback = function(server: PUA_Server;
    const sessionId: PUA_NodeId; sessionContext: pointer;
    const methodId: PUA_NodeId; methodContext: pointer;
    const objectId: PUA_NodeId; objectContext: pointer;
    inputSize: SIZE_T; const input: PUA_Variant;
    outputSize: SIZE_T; output: PUA_Variant): UA_StatusCode; cdecl;

  UA_ServerConfig = record
    logger: UA_Logger;
    buildInfo: UA_BuildInfo;
    applicationDescription: UA_ApplicationDescription;
    serverCertificate: UA_ByteString;
    shutdownDelay: UA_Double;
    verifyRequestTimestamp: UA_RuleHandling;
    allowEmptyVariables: UA_RuleHandling;
    customDataTypes: PUA_DataTypeArray;
    networkLayersSize: size_t;
    networkLayers: PUA_ServerNetworkLayer;
    customHostname: UA_String;
  end;
  PUA_ServerConfig = ^UA_ServerConfig;

const
  UA_ACCESSLEVELMASK_READ = $01 shl 0;
  UA_ACCESSLEVELMASK_WRITE = $01 shl 1;
  UA_ACCESSLEVELMASK_HISTORYREAD = $01 shl 2;
  UA_ACCESSLEVELMASK_HISTORYWRITE = $01 shl 3;
  UA_ACCESSLEVELMASK_SEMANTICCHANGE = $01 shl 4;
  UA_ACCESSLEVELMASK_STATUSWRITE = $01 shl 5;
  UA_ACCESSLEVELMASK_TIMESTAMPWRITE = $01 shl 6;

  UA_STRING_NULL: UA_String = (length: 0; data: nil);
  UA_BYTESTRING_NULL: UA_ByteString = (length: 0; data: nil);
  UA_GUID_NULL: UA_Guid = (data1: 0; data2: 0; data3: 0; data4: (0, 0, 0, 0, 0, 0, 0, 0));
  UA_NODEID_NULL: UA_NodeId = (namespaceIndex: 0; identifierType: UA_NODEIDTYPE_NUMERIC; identifier: (numeric: 0));

  UA_EMPTY_ARRAY_SENTINEL = Pointer($01);


var
  UA_TYPES: PUA_DataType;
  UA_VariableAttributes_default: UA_VariableAttributes;
  UA_ObjectAttributes_default: UA_ObjectAttributes;
  UA_ObjectTypeAttributes_default: UA_ObjectTypeAttributes;
  UA_ReferenceTypeAttributes_default: UA_ReferenceTypeAttributes;
  UA_DataTypeAttributes_default: UA_DataTypeAttributes;

  UA_Client_new: function(): PUA_Client; cdecl;
  UA_Client_newWithConfig: function(const config: PUA_ClientConfig): PUA_Client; cdecl;
  UA_Client_getState: procedure(client: PUA_Client; channelState: PUA_SecureChannelState; sessionState: PUA_SessionState; connectStatus: PUA_StatusCode); cdecl;

  UA_Client_getConfig: function(client: PUA_Client): PUA_ClientConfig; cdecl;

  UA_ClientConfig_setDefault: function(config: PUA_ClientConfig): UA_StatusCode; cdecl;
  UA_Client_delete: procedure(client: PUA_Client); cdecl;
  __UA_Client_connect: function(client: PUA_Client; async: UA_Boolean): UA_StatusCode; cdecl;
  UA_Client_connectSecureChannel: function(client: PUA_Client; endpointUrl: PAnsiChar): UA_StatusCode; cdecl;
  UA_Client_activateSession: function(client: PUA_Client): UA_StatusCode; cdecl;

  UA_Client_disconnect: function(client: PUA_Client): UA_StatusCode; cdecl;
  __UA_Client_Service: procedure(client: PUA_Client; const request: Pointer; const requestType: PUA_DataType; response: Pointer; const responseType: PUA_DataType); cdecl;
  UA_Client_run_iterate: function(client: PUA_Client; timeout: UA_UInt32): UA_StatusCode; cdecl;

  UA_StatusCode_name: function(code: UA_StatusCode): PAnsiChar; cdecl;
  UA_String_fromChars: function(src: PAnsiChar): UA_String; cdecl;
  UA_String_equal_ignorecase: function(const s1, s2: PUA_String): UA_Boolean; cdecl;
  UA_NodeId_isNull: function(p: PUA_NodeId): UA_Boolean; cdecl;
  UA_NodeId_print: function(id: PUA_NodeId; output: PUA_String): UA_StatusCode; cdecl;
  UA_NumericRange_parse: function(range: PUA_NumericRange; const str: UA_String): UA_StatusCode; cdecl;
  UA_Variant_setScalar: procedure(v: PUA_Variant; p: Pointer; _type: PUA_DataType); cdecl;
  UA_Variant_setScalarCopy: function(v: PUA_Variant; p: Pointer; _type: PUA_DataType): UA_StatusCode; cdecl;
  UA_Variant_setArray: procedure(v: PUA_Variant; arrayData: Pointer; arraySize: size_t; _type: PUA_DataType); cdecl;
  UA_Variant_setArrayCopy: function(v: PUA_Variant; arrayData: Pointer; arraySize: size_t; _type: PUA_DataType): UA_StatusCode; cdecl;
  UA_DateTime_toStruct: function(t: UA_DateTime): UA_DateTimeStruct; cdecl;
  UA_DateTime_fromStruct: function(ts: UA_DateTimeStruct): UA_DateTime; cdecl;
  UA_findDataType: function(typeId: PUA_NodeId): PUA_DataType; cdecl;

  UA_new: function(const _type: PUA_DataType): Pointer; cdecl;
  UA_copy: function(src, dst: Pointer; const _type: PUA_DataType): UA_StatusCode; cdecl;
  UA_clear: procedure(p: Pointer; typeDesc: PUA_DataType); cdecl;
  UA_delete: procedure(p: Pointer; const _type: PUA_DataType); cdecl;
  UA_Array_delete: procedure(p: Pointer; size: size_t; const _type: PUA_DataType); cdecl;

  __UA_Client_readAttribute: function(client: PUA_Client; const nodeId: PUA_NodeId; attributeId: UA_AttributeId; _out: Pointer; outDataType: PUA_DataType): UA_StatusCode; cdecl;
  UA_Client_readArrayDimensionsAttribute: function(client: PUA_Client; const nodeId: UA_NodeId; out outArrayDimensionsSize: size_t; out outArrayDimensions: PUA_UInt32): UA_StatusCode; cdecl;

  __UA_Client_writeAttribute: function(client: PUA_Client; const nodeId: PUA_NodeId; attributeId: UA_AttributeId; _in: Pointer; inDataType: PUA_DataType): UA_StatusCode; cdecl;
  UA_Client_writeArrayDimensionsAttribute: function(client: PUA_Client; const nodeId: UA_NodeId; newArrayDimensionsSize: size_t; newArrayDimensions: PUA_UInt32): UA_StatusCode;
  UA_Client_call: function(client: PUA_Client; const objectId, methodId: UA_NodeId; inputSize: size_t; input: PUA_Variant; out outputSize: size_t; out output: PUA_Variant): UA_StatusCode; cdecl;

  UA_Client_Subscriptions_create: function(client: PUA_Client; const request: UA_CreateSubscriptionRequest; subscriptionContext: Pointer; statusChangeCallback: UA_Client_StatusChangeNotificationCallback; deleteCallback: UA_Client_DeleteSubscriptionCallback): UA_CreateSubscriptionResponse; cdecl;
  UA_Client_Subscriptions_delete: function(client: PUA_Client; const request: UA_DeleteSubscriptionsRequest): UA_DeleteSubscriptionsResponse; cdecl;
  UA_Client_Subscriptions_deleteSingle: function(client: PUA_Client; subscriptionId: UA_UInt32): UA_StatusCode; cdecl;
  UA_Client_MonitoredItems_createDataChange: function(client: PUA_Client; subscriptionId: UA_UInt32; timestampsToReturn: UA_TimestampsToReturn; const item: UA_MonitoredItemCreateRequest; context: Pointer; callback: UA_Client_DataChangeNotificationCallback; deleteCallback: UA_Client_DeleteMonitoredItemCallback): UA_MonitoredItemCreateResult; cdecl;
  UA_Client_MonitoredItems_deleteSingle: function(client: PUA_Client; subscriptionId: UA_UInt32; monitoredItemId: UA_UInt32): UA_StatusCode; cdecl;

  UA_Server_new: function(): PUA_Server; cdecl;
  UA_ServerConfig_setMinimalCustomBuffer: function(config: PUA_ServerConfig; portNumber: UA_UInt16; const certificate: PUA_ByteString; sendBufferSize, recvBufferSize: UA_UInt32): UA_StatusCode; cdecl;
  UA_Server_delete: procedure(server: PUA_Server); cdecl;
  UA_Server_getConfig: function(server: PUA_Server): PUA_ServerConfig; cdecl;
  UA_Server_run: function(server: PUA_Server; running: PUA_Boolean): UA_StatusCode; cdecl;
  UA_Server_run_startup: function(server: PUA_Server): UA_StatusCode; cdecl;
  UA_Server_run_iterate: function(server: PUA_Server; waitInternal: UA_Boolean): UA_UInt16; cdecl;
  UA_Server_run_shutdown: function(server: PUA_Server): UA_StatusCode; cdecl;
  __UA_Server_addNode: function(server: PUA_Server; const nodeClass: UA_NodeClass;
    const requestedNewNodeId: PUA_NodeId;
    const parentNodeId: PUA_NodeId;
    const referenceTypeId: PUA_NodeId;
    const browseName: UA_QualifiedName;
    const typeDefinition: PUA_NodeId;
    const attr: PUA_NodeAttributes;
    const attributeType: PUA_DataType;
    nodeContext: Pointer; outNewNodeId: PUA_NodeId): UA_StatusCode; cdecl;
  __UA_Server_write: function(server: PUA_Server; const nodeId: PUA_NodeId; const attributeId: UA_AttributeId; const attr_type: PUA_DataType; attr: Pointer): UA_StatusCode; cdecl;
  UA_Server_addReference: function(server: PUA_Server; const sourceId: UA_NodeId;
    const refTypeId: UA_NodeId;
    const targetId: UA_ExpandedNodeId; isForward: UA_Boolean): UA_StatusCode; cdecl;
  UA_Server_deleteReference: function(server: PUA_Server; const sourceNodeId: UA_NodeId;
    const referenceTypeId: UA_NodeId; isForward: UA_Boolean;
    const targetNodeId: UA_ExpandedNodeId; deleteBitirectional: UA_Boolean): UA_StatusCode; cdecl;
  UA_Server_addNamespace: function(server: PUA_Server; namespace: PChar): UA_Uint16; cdecl;
  UA_Server_addMethodNodeEx: function(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
    const parentNodeId: UA_NodeId;
    const referenceTypeId: UA_NodeId;
    const browseName: UA_QualifiedName;
    const attr: UA_MethodAttributes; method: UA_MethodCallback;
    inputArgumentsSize: SIZE_T; const inputArguments: PUA_Argument;
    const inputArgumentsRequestedNewNodeId: UA_NodeId;
    inputArgumentsOutNewNodeId: PUA_NodeId;
    outputArgumentsSize: SIZE_T; const outputArguments: PUA_Argument;
    const outputArgumentsRequestedNewNodeId: UA_NodeId;
    outputArgumentsOutNewNodeId: PUA_NodeId;
    nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode; cdecl;
  UA_MethodAttributes_default: UA_MethodAttributes;

function LoadOpen62541: Boolean;
procedure UnloadOpen62541;

function AssignedProc(p: Pointer): Boolean; inline;
function AllOpen62541FunctionsLoaded: Boolean;
function OpcUaClientConnect(client: PUA_Client; endpointUrl: PAnsiChar): UA_StatusCode; cdecl;
function UA_StringFromVariant(const v: UA_Variant): string;

function _UA_StatusCode_Name(code: UA_StatusCode): AnsiString;
function _UA_STRING(var chars: AnsiString): UA_String; inline;
function _UA_String_Alloc(const chars: AnsiString): UA_String; inline;
function _UA_BYTESTRING(var chars: AnsiString): UA_ByteString; inline;
function _UA_BYTESTRING_ALLOC(const chars: AnsiString): UA_ByteString; inline;
function _UA_QUALIFIEDNAME(nsIndex: UA_UInt16; var chars: AnsiString): UA_QualifiedName;
function _UA_QUALIFIEDNAME_ALLOC(nsIndex: UA_UInt16; const chars: AnsiString): UA_QualifiedName; inline;
function _UA_LOCALIZEDTEXT(var locale, text: AnsiString): UA_LocalizedText;
function _UA_LOCALIZEDTEXT_ALLOC(const locale, text: AnsiString): UA_LocalizedText; inline;
function _UA_NUMERICRANGE(const s: AnsiString): UA_NumericRange;
function _UA_String_equal(const s1: UA_String; const s2: AnsiString): boolean; overload;

function UA_StringToStr(const s: UA_String): AnsiString;
function UA_LocalizedTextToStr(const t: UA_LocalizedText): AnsiString;
function UA_NodeIdToStr(const id: UA_NodeId): AnsiString;
function UA_DataTypeToStr(typeId: UA_NodeId): AnsiString;
function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const indexRange: AnsiString; out outValue: UA_Variant): UA_StatusCode; overload;

function UA_Variant_isEmpty(const v: PUA_Variant): Boolean;
function UA_Variant_isScalar(const v: PUA_Variant): Boolean;
function UA_Variant_hasScalarType(const v: PUA_Variant; const _type: PUA_DataType): Boolean;
function UA_Variant_hasArrayType(const v: PUA_Variant; const _type: PUA_DataType): Boolean;

function UA_Variant_getFloat(var v: UA_Variant): single;
function UA_Variant_getDouble(var v: UA_Variant): double;
function UA_Variant_getByte(var v: UA_Variant): Byte;
function UA_Variant_getSmallint(var v: UA_Variant): Smallint;
function UA_Variant_getInteger(var v: UA_Variant): Integer;
function UA_Variant_getInt64(var v: UA_Variant): Int64;
function UA_Variant_getString(var v: UA_Variant): AnsiString; overload;
function UA_Variant_getString(var v: UA_Variant; arrayIndex: DWord): AnsiString; overload;

procedure UA_Variant_setBoolean(out v: UA_Variant; b: bytebool);
procedure UA_Variant_setFloat(out v: UA_Variant; f: single);
procedure UA_Variant_setDouble(out v: UA_Variant; d: double);
procedure UA_Variant_setByte(out v: UA_Variant; i: Byte);
procedure UA_Variant_setSmallint(out v: UA_Variant; i: Smallint);
procedure UA_Variant_setUInt16(out v: UA_Variant; i: UInt16);
procedure UA_Variant_setInteger(out v: UA_Variant; i: Integer);
procedure UA_Variant_setUInt32(out v: UA_Variant; i: UInt32);
procedure UA_Variant_setInt64(out v: UA_Variant; i: Int64);
procedure UA_Variant_setUInt64(out v: UA_Variant; i: UInt64);
procedure UA_Variant_setString(out v: UA_Variant; const s: AnsiString);

function UA_NODEID_NUMERIC(nsIndex: UA_UInt16; identifier: UA_UInt32): UA_NodeId;
function UA_NODEID_STRING(nsIndex: UA_UInt16; var chars: AnsiString): UA_NodeId;
function UA_NODEID_STRING_ALLOC(nsIndex: UA_UInt16; const chars: AnsiString): UA_NodeId;
function UA_NODEID_GUID(nsIndex: UA_UInt16; guid: UA_Guid): UA_NodeId;
function UA_NODEID_BYTESTRING(nsIndex: UA_UInt16; var chars: AnsiString): UA_NodeId;
function UA_NODEID_BYTESTRING_ALLOC(nsIndex: UA_UInt16; const chars: AnsiString): UA_NodeId;
function UA_EXPANDEDNODEID_NUMERIC(nsIndex: UA_UInt16; identifier: UA_Uint32): UA_ExpandedNodeId;

procedure UA_init(p: Pointer; const _type: PUA_DataType);

procedure UA_Variant_init(out p: UA_Variant);
procedure UA_Variant_clear(var p: UA_Variant);
procedure UA_String_clear(p: PUA_String); cdecl;
procedure UA_NodeId_clear(var p: UA_NodeId);
procedure UA_CreateSubscriptionRequest_init(out p: UA_CreateSubscriptionRequest);
procedure UA_MonitoredItemCreateRequest_init(out p: UA_MonitoredItemCreateRequest);

procedure UA_BrowseRequest_init(out p: UA_BrowseRequest);
function UA_BrowseRequest_new: PUA_BrowseRequest;
function UA_BrowseRequest_copy(const src: UA_BrowseRequest; out dst: UA_BrowseRequest): UA_StatusCode;
procedure UA_BrowseRequest_deleteMembers(var p: UA_BrowseRequest);
procedure UA_BrowseRequest_clear(var p: UA_BrowseRequest);
procedure UA_BrowseRequest_delete(p: PUA_BrowseRequest);

procedure UA_BrowseResponse_init(out p: UA_BrowseResponse);
function UA_BrowseResponse_new: PUA_BrowseResponse;
function UA_BrowseResponse_copy(const src: UA_BrowseResponse; out dst: UA_BrowseResponse): UA_StatusCode;
procedure UA_BrowseResponse_deleteMembers(var p: UA_BrowseResponse);
procedure UA_BrowseResponse_clear(var p: UA_BrowseResponse);
procedure UA_BrowseResponse_delete(p: PUA_BrowseResponse);

procedure UA_BrowseDescription_init(out p: UA_BrowseDescription);
function UA_BrowseDescription_new: PUA_BrowseDescription;
function UA_BrowseDescription_copy(const src: UA_BrowseDescription; out dst: UA_BrowseDescription): UA_StatusCode;
procedure UA_BrowseDescription_deleteMembers(var p: UA_BrowseDescription);
procedure UA_BrowseDescription_clear(var p: UA_BrowseDescription);
procedure UA_BrowseDescription_delete(p: PUA_BrowseDescription);

function UA_Client_connect_username(client: PUA_Client; const endpointUrl, username, password: AnsiString): UA_StatusCode; deprecated;
function UA_Client_connectUsername(client: PUA_Client; const endpointUrl, username, password: AnsiString): UA_StatusCode;
function UA_Client_Service_read(client: PUA_Client; const request: UA_ReadRequest): UA_ReadResponse;
function UA_Client_Service_browse(client: PUA_Client; const request: UA_BrowseRequest): UA_BrowseResponse;

function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: UA_Variant): UA_StatusCode; overload;
function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: Byte): UA_StatusCode; overload;
function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: Smallint): UA_StatusCode; overload;
function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: Longint): UA_StatusCode; overload;
function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: AnsiString): UA_StatusCode; overload;
function UA_Client_readDataTypeAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outDataType: UA_NodeId): UA_StatusCode;
function UA_Client_readValueRankAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValueRank: UA_Int32): UA_StatusCode;
function UA_Client_readBrowseNameAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outBrowseName: UA_QualifiedName): UA_StatusCode;
function UA_Client_readDisplayNameAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outDisplayName: UA_LocalizedText): UA_StatusCode;
function UA_Client_readDescriptionAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outDescription: UA_LocalizedText): UA_StatusCode;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Variant): UA_StatusCode; overload;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: Byte): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: Smallint): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: Longint): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: AnsiString): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Double): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Boolean): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_UInt16): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_UInt32): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Int64): UA_StatusCode; overload;
function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Float): UA_StatusCode; overload;

function UA_Client_writeDescriptionAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newDescription: UA_LocalizedText): UA_StatusCode;
function UA_Client_writeDataTypeAttribute(client: PUA_Client; const nodeId: UA_NodeId; newDataType: PUA_NodeId): UA_StatusCode;
function UA_Client_writeValueRankAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValueRank: UA_Int32): UA_StatusCode;

function UA_CreateSubscriptionRequest_default(): UA_CreateSubscriptionRequest;
function UA_MonitoredItemCreateRequest_default(nodeId: UA_NodeId): UA_MonitoredItemCreateRequest;

function UA_ServerConfig_setDefault(config: PUA_ServerConfig): UA_StatusCode;
function UA_ServerConfig_setMinimal(config: PUA_ServerConfig; portNumber: UA_UInt16; const certificate: PUA_ByteString): UA_StatusCode;

function UA_Server_addVariableNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const typeDefinition: UA_NodeId;
  const attr: UA_VariableAttributes;
  nodeContext: Pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
function UA_Server_addObjectTypeNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_ObjectTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
function UA_Server_addObjectNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const typeDefinition: UA_NodeId;
  const attr: UA_ObjectAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
function UA_Server_addVariableTypeNode(server: PUA_Server;
  const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const typeDefinition: UA_NodeId;
  const attr: UA_VariableTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
function UA_Server_addViewNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_ViewAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
function UA_Server_addReferenceTypeNode(server: PUA_Server;
  const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_ReferenceTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
function UA_Server_addDataTypeNode(server: PUA_Server;
  const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_DataTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
function UA_Server_writeValue(server: PUA_Server; const nodeId: UA_NodeId; const value: UA_Variant): UA_StatusCode;
function UA_Server_addMethodNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_MethodAttributes; method: UA_MethodCallback;
  inputArgumentsSize: SIZE_T; const inputArguments: PUA_Argument;
  outputArgumentsSize: SIZE_T; const outputArguments: PUA_Argument;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;

type
  PUA_ClientConfigHeader = ^UA_ClientConfigHeader;
  UA_ClientConfigHeader = record clientContext: Pointer; logging: Pointer;
    timeout: UA_UInt32;
    clientDescription: UA_ApplicationDescription;
    endpointUrl: UA_String;
    userIdentityToken: UA_ExtensionObject;
    securityMode: UA_UInt32;
    securityPolicyUri: UA_String;
    noSession: UA_Boolean;
  end;

implementation

uses
  Winapi.Windows,
  System.SysUtils;

var
  Open62541LibHandle: THandle;
  RefCount: Integer;

function UA_StringFromVariant(const v: UA_Variant): string;
var
  uaStr: PUA_String;
  tmp: AnsiString;
begin
  Result := '';
  if not UA_Variant_hasScalarType(@v, @UA_TYPES[UA_TYPES_STRING]) then
    Exit;
  uaStr := PUA_String(v.data);
  if (uaStr = nil) or (uaStr^.length = 0) then
    Exit;
  SetString(tmp, PAnsiChar(uaStr^.data), uaStr^.length);
  Result := string(tmp);
end;

function OpcUaClientConnect(client: PUA_Client; endpointUrl: PAnsiChar): UA_StatusCode; cdecl;
var
  cc: PUA_ClientConfigHeader;
begin
  cc := PUA_ClientConfigHeader(UA_Client_getConfig(client));

  cc^.noSession := UA_Boolean(False);

  UA_String_clear(@cc^.endpointUrl);
  cc^.endpointUrl := UA_String_fromChars(endpointUrl);

  Result := __UA_Client_connect(client, UA_Boolean(False));
end;

function GetProcedureAddress(Lib: THandle; ProcName: PAnsiChar): Pointer; inline;
begin
  Result := Winapi.Windows.GetProcAddress(Lib, ProcName);
end;

function UnloadLibrary(Lib: THandle): Boolean; inline;
begin
  Result := Winapi.Windows.FreeLibrary(Lib);
end;

function GetLoadErrorStr: string; inline;
begin
  Result := System.Sysutils.SysErrorMessage(GetLastError);
end;

function AssignedProc(p: Pointer): Boolean; inline;
begin
  Result := p <> nil;
end;

function AllOpen62541FunctionsLoaded: Boolean;
begin
  Result :=
  AssignedProc(@UA_Client_new) and
  AssignedProc(@UA_Client_newWithConfig) and
  AssignedProc(@UA_Client_getState) and
  AssignedProc(@UA_Client_getConfig) and
  AssignedProc(@UA_ClientConfig_setDefault) and

  AssignedProc(@UA_Client_delete) and
  AssignedProc(@UA_StatusCode_name) and
  AssignedProc(@__UA_Client_connect) and
  AssignedProc(@UA_Client_activateSession) and

  AssignedProc(@UA_Client_disconnect) and
  AssignedProc(@__UA_Client_Service) and
  AssignedProc(@UA_Client_run_iterate) and

  AssignedProc(@UA_String_fromChars) and
  AssignedProc(@UA_String_equal_ignorecase) and
  AssignedProc(@UA_NodeId_isNull) and
  AssignedProc(@UA_NodeId_print) and
  AssignedProc(@UA_NumericRange_parse) and
  AssignedProc(@UA_Variant_setScalar) and
  AssignedProc(@UA_Variant_setScalarCopy) and
  AssignedProc(@UA_Variant_setArray) and
  AssignedProc(@UA_Variant_setArrayCopy) and
  AssignedProc(@UA_DateTime_toStruct) and
  AssignedProc(@UA_DateTime_fromStruct) and
  AssignedProc(@UA_findDataType) and

  AssignedProc(@UA_new) and
  AssignedProc(@UA_copy) and
  AssignedProc(@UA_clear) and
  AssignedProc(@UA_delete) and
  AssignedProc(@UA_Array_delete) and

  AssignedProc(@__UA_Client_readAttribute) and
  AssignedProc(@UA_Client_readArrayDimensionsAttribute) and
  AssignedProc(@__UA_Client_writeAttribute) and
  AssignedProc(@UA_Client_writeArrayDimensionsAttribute) and
  AssignedProc(@UA_Client_call) and

  AssignedProc(@UA_Client_Subscriptions_create) and
  AssignedProc(@UA_Client_Subscriptions_delete) and
  AssignedProc(@UA_Client_Subscriptions_deleteSingle) and
  AssignedProc(@UA_Client_MonitoredItems_createDataChange) and
  AssignedProc(@UA_Client_MonitoredItems_deleteSingle) and

  AssignedProc(@UA_Server_new) and
  AssignedProc(@UA_ServerConfig_setMinimalCustomBuffer) and
  AssignedProc(@UA_Server_delete) and
  AssignedProc(@UA_Server_getConfig) and
  AssignedProc(@UA_Server_run) and
  AssignedProc(@UA_Server_run_startup) and
  AssignedProc(@UA_Server_run_iterate) and
  AssignedProc(@UA_Server_run_shutdown) and

  AssignedProc(@__UA_Server_addNode) and
  AssignedProc(@UA_Server_addReference) and
  AssignedProc(@UA_Server_deleteReference) and
  AssignedProc(@__UA_Server_write) and
  AssignedProc(@UA_Server_addNamespace) and

  AssignedProc(@UA_Server_addMethodNodeEx);
end;

function LoadOpen62541: Boolean;
var
  p: Pointer;
begin
  Inc(RefCount);
  if RefCount = 1 then begin
    open62541LibHandle := LoadLibrary(LibOpen62541);
    if open62541LibHandle = 0 then begin
      RefCount := 0;
      Result := False;
      Exit;
    end;

    pointer(UA_TYPES) := GetProcedureAddress(open62541LibHandle, 'UA_TYPES');

    p := GetProcedureAddress(open62541LibHandle, 'UA_VariableAttributes_default');
    if p = nil then begin
      UnloadOpen62541; RefCount := 0; Exit(False);
    end;
    UA_VariableAttributes_default := PUA_VariableAttributes(p)^;

    p := GetProcedureAddress(open62541LibHandle, 'UA_MethodAttributes_default');
    if p = nil then begin
      UnloadOpen62541; RefCount := 0; Exit(False);
    end;
    UA_MethodAttributes_default := PUA_MethodAttributes(p)^;

    p := GetProcedureAddress(open62541LibHandle, 'UA_ObjectAttributes_default');
    if p = nil then begin
      UnloadOpen62541; RefCount := 0; Exit(False);
    end;
    UA_ObjectAttributes_default := PUA_ObjectAttributes(p)^;

    p := GetProcedureAddress(open62541LibHandle, 'UA_ObjectTypeAttributes_default');
    if p = nil then begin
      UnloadOpen62541; RefCount := 0; Exit(False);
    end;
    UA_ObjectTypeAttributes_default := PUA_ObjectTypeAttributes(p)^;

    p := GetProcedureAddress(open62541LibHandle, 'UA_ReferenceTypeAttributes_default');
    if p = nil then begin
      UnloadOpen62541; RefCount := 0; Exit(False);
    end;
    UA_ReferenceTypeAttributes_default := PUA_ReferenceTypeAttributes(p)^;

    p := GetProcedureAddress(open62541LibHandle, 'UA_DataTypeAttributes_default');
    if p = nil then begin
      UnloadOpen62541; RefCount := 0; Exit(False);
    end;
    UA_DataTypeAttributes_default := PUA_DataTypeAttributes(p)^;

    if UA_TYPES = nil then begin
      UnloadOpen62541;
      RefCount := 0;
      Exit(False);
    end;

    @UA_Client_new := GetProcedureAddress(open62541LibHandle, 'UA_Client_new');
    @UA_Client_newWithConfig := GetProcedureAddress(open62541LibHandle, 'UA_Client_newWithConfig');
    @UA_Client_getState := GetProcedureAddress(open62541LibHandle, 'UA_Client_getState');
    @UA_Client_getConfig := GetProcedureAddress(open62541LibHandle, 'UA_Client_getConfig');
    @UA_ClientConfig_setDefault := GetProcedureAddress(open62541LibHandle, 'UA_ClientConfig_setDefault');
    @UA_Client_delete := GetProcedureAddress(open62541LibHandle, 'UA_Client_delete');
    @UA_StatusCode_name := GetProcedureAddress(open62541LibHandle, 'UA_StatusCode_name');
    @__UA_Client_connect := GetProcedureAddress(open62541LibHandle, '__UA_Client_connect');
    @UA_Client_connectSecureChannel := GetProcedureAddress(open62541LibHandle, 'UA_Client_connectSecureChannel');
    @UA_Client_activateSession := GetProcedureAddress(open62541LibHandle, 'UA_Client_activateSession');
    @UA_Client_disconnect := GetProcedureAddress(open62541LibHandle, 'UA_Client_disconnect');
    @__UA_Client_Service := GetProcedureAddress(open62541LibHandle, '__UA_Client_Service');
    @UA_Client_run_iterate := GetProcedureAddress(open62541LibHandle, 'UA_Client_run_iterate');

    @UA_String_fromChars := GetProcedureAddress(open62541LibHandle, 'UA_String_fromChars');
    @UA_String_equal_ignorecase := GetProcedureAddress(open62541LibHandle, 'UA_String_equal_ignorecase');
    @UA_NodeId_isNull := GetProcedureAddress(open62541LibHandle, 'UA_NodeId_isNull');
    @UA_NodeId_print := GetProcedureAddress(open62541LibHandle, 'UA_NodeId_print');
    @UA_NumericRange_parse := GetProcedureAddress(open62541LibHandle, 'UA_NumericRange_parse');
    @UA_Variant_setScalar := GetProcedureAddress(open62541LibHandle, 'UA_Variant_setScalar');
    @UA_Variant_setScalarCopy := GetProcedureAddress(open62541LibHandle, 'UA_Variant_setScalarCopy');
    @UA_Variant_setArray := GetProcedureAddress(open62541LibHandle, 'UA_Variant_setArray');
    @UA_Variant_setArrayCopy := GetProcedureAddress(open62541LibHandle, 'UA_Variant_setArrayCopy');
    @UA_DateTime_toStruct := GetProcedureAddress(open62541LibHandle, 'UA_DateTime_toStruct');
    @UA_DateTime_fromStruct := GetProcedureAddress(open62541LibHandle, 'UA_DateTime_fromStruct');
    @UA_findDataType := GetProcedureAddress(open62541LibHandle, 'UA_findDataType');

    @UA_new := GetProcedureAddress(open62541LibHandle, 'UA_new');
    @UA_copy := GetProcedureAddress(open62541LibHandle, 'UA_copy');

    @UA_clear := GetProcedureAddress(open62541LibHandle, 'UA_clear');

    @UA_delete := GetProcedureAddress(open62541LibHandle, 'UA_delete');
    @UA_Array_delete := GetProcedureAddress(open62541LibHandle, 'UA_Array_delete');

    @__UA_Client_readAttribute := GetProcedureAddress(open62541LibHandle, '__UA_Client_readAttribute');
    @UA_Client_readArrayDimensionsAttribute := GetProcedureAddress(open62541LibHandle, 'UA_Client_readArrayDimensionsAttribute');
    @__UA_Client_writeAttribute := GetProcedureAddress(open62541LibHandle, '__UA_Client_writeAttribute');
    @UA_Client_writeArrayDimensionsAttribute := GetProcedureAddress(open62541LibHandle, 'UA_Client_writeArrayDimensionsAttribute');
    @UA_Client_call := GetProcedureAddress(open62541LibHandle, 'UA_Client_call');

    @UA_Client_Subscriptions_create := GetProcedureAddress(open62541LibHandle, 'UA_Client_Subscriptions_create');
    @UA_Client_Subscriptions_delete := GetProcedureAddress(open62541LibHandle, 'UA_Client_Subscriptions_delete');
    @UA_Client_Subscriptions_deleteSingle := GetProcedureAddress(open62541LibHandle, 'UA_Client_Subscriptions_deleteSingle');
    @UA_Client_MonitoredItems_createDataChange := GetProcedureAddress(open62541LibHandle, 'UA_Client_MonitoredItems_createDataChange');
    @UA_Client_MonitoredItems_deleteSingle := GetProcedureAddress(open62541LibHandle, 'UA_Client_MonitoredItems_deleteSingle');

    @UA_Server_new := GetProcedureAddress(open62541LibHandle, 'UA_Server_new');
    @UA_ServerConfig_setMinimalCustomBuffer := GetProcedureAddress(open62541LibHandle, 'UA_ServerConfig_setMinimalCustomBuffer');
    @UA_Server_delete := GetProcedureAddress(open62541LibHandle, 'UA_Server_delete');
    @UA_Server_getConfig := GetProcedureAddress(open62541LibHandle, 'UA_Server_getConfig');
    @UA_Server_run := GetProcedureAddress(open62541LibHandle, 'UA_Server_run');
    @UA_Server_run_startup := GetProcedureAddress(open62541LibHandle, 'UA_Server_run_startup');
    @UA_Server_run_iterate := GetProcedureAddress(open62541LibHandle, 'UA_Server_run_iterate');
    @UA_Server_run_shutdown := GetProcedureAddress(open62541LibHandle, 'UA_Server_run_shutdown');

    @__UA_Server_addNode := GetProcedureAddress(open62541LibHandle, '__UA_Server_addNode');
    @UA_Server_addReference := GetProcedureAddress(open62541LibHandle, 'UA_Server_addReference');
    @UA_Server_deleteReference := GetProcedureAddress(open62541LibHandle, 'UA_Server_deleteReference');
    @__UA_Server_write := GetProcedureAddress(open62541LibHandle, '__UA_Server_write');
    @UA_Server_addNamespace := GetProcedureAddress(open62541LibHandle, 'UA_Server_addNamespace');
    @UA_Server_addMethodNodeEx := GetProcedureAddress(open62541LibHandle, 'UA_Server_addMethodNodeEx');

    if not AllOpen62541FunctionsLoaded then begin
      UnloadOpen62541;
      RefCount := 0;
      Result := False;
      Exit;
    end;

    Result := True;
  end else
    Result := True;
end;

procedure UnloadOpen62541;
begin
  if RefCount > 0 then begin
    Dec(RefCount);
    if RefCount = 0 then begin
      UnloadLibrary(open62541LibHandle);
    end;
  end;
end;

function _UA_StatusCode_Name(code: UA_StatusCode): AnsiString;
begin
  Result := AnsiString(Format('%x:%s', [code, UA_StatusCode_name(code)]));
end;

function _UA_STRING(var chars: AnsiString): UA_String; inline;
begin
  if chars = '' then begin
    Result.length := 0;
    Result.data := nil;
  end else begin
    Result.length := Length(chars);
    Result.data := @chars[1];
  end;
end;

function _UA_STRING_ALLOC(const chars: AnsiString): UA_String; inline;
var
  bs: UA_BYTESTRING;
begin
  if chars = '' then begin
    result.length := 0;
    result.data := nil;
  end else begin
    bs.length := length(chars);
    bs.data := @chars[1];
    UA_copy(@bs, @result, @UA_TYPES[UA_TYPES_BYTESTRING]);
  end;
end;

function _UA_BYTESTRING(var chars: AnsiString): UA_ByteString;
begin
  result := UA_ByteString(_UA_STRING(chars));
end;

function _UA_BYTESTRING_ALLOC(const chars: AnsiString): UA_ByteString; inline;
begin
  result := UA_ByteString(_UA_STRING_ALLOC(chars));
end;

function _UA_QUALIFIEDNAME(nsIndex: UA_UInt16; var chars: AnsiString): UA_QualifiedName;
begin
  Result.namespaceIndex := nsIndex;
  Result.name := _UA_STRING(chars);
end;

function _UA_QUALIFIEDNAME_ALLOC(nsIndex: UA_UInt16; const chars: AnsiString): UA_QualifiedName;
begin
  Result.namespaceIndex := nsIndex;
  Result.name := _UA_STRING_ALLOC(chars);
end;

function _UA_LOCALIZEDTEXT(var locale, text: AnsiString): UA_LocalizedText;
begin
  Result.locale := _UA_STRING(locale);
  Result.text := _UA_STRING(text);
end;

function _UA_LOCALIZEDTEXT_ALLOC(const locale, text: AnsiString): UA_LocalizedText;
begin
  Result.locale := _UA_STRING_ALLOC(locale);
  Result.text := _UA_STRING_ALLOC(text)
end;

function _UA_NUMERICRANGE(const s: AnsiString): UA_NumericRange;
var
  uas: UA_String;
begin
  Result.dimensionsSize := 0;
  Result.dimensions := nil;
  uas := _UA_STRING_ALLOC(s);
  UA_NumericRange_parse(@Result, uas);
  UA_String_clear(@uas);
end;

function _UA_String_equal(const s1: UA_String; const s2: AnsiString): boolean; overload;
var
  s: UA_String;
begin
  s := _UA_STRING_ALLOC(s2);
  Result := UA_String_equal_ignorecase(@s1, @s);
  UA_String_clear(@s);
end;

function UA_StringToStr(const s: UA_String): AnsiString;
begin
  SetString(Result, PAnsiChar(s.data), s.length);
end;

function UA_LocalizedTextToStr(const t: UA_LocalizedText): AnsiString;
begin
  SetString(Result, PAnsiChar(t.text.data), t.text.length);
end;

function UA_NodeIdToStr(const id: UA_NodeId): AnsiString;
var
  output: UA_String;
begin
  output := UA_STRING_NULL;
  UA_NodeId_print(@id, @output);
  SetString(Result, PAnsiChar(output.data), output.length);
  UA_String_Clear(@output);
end;

function UA_DataTypeToStr(typeId: UA_NodeId): AnsiString;
var
  pDataType: PUA_DataType;
begin
  pDataType := UA_findDataType(@typeId);
  if pDataType = nil then
    Result := 'Unknown'
  else
    Result := pDataType^.typeName;
end;

procedure UA_Variant_init(out p: UA_Variant);
begin
  FillChar(p, SizeOf(UA_Variant), #0);
end;

procedure UA_Variant_clear(var p: UA_Variant);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_VARIANT]);
end;

procedure UA_String_clear(p: PUA_String); cdecl;
begin
  UA_clear(p, @UA_TYPES[UA_TYPES_STRING]);
end;

procedure UA_NodeId_clear(var p: UA_NodeId);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_NODEID]);
end;

procedure UA_CreateSubscriptionRequest_init(out p: UA_CreateSubscriptionRequest);
begin
  FillChar(p, SizeOf(p), #0);
end;

procedure UA_MonitoredItemCreateRequest_init(out p: UA_MonitoredItemCreateRequest);
begin
  FillChar(p, SizeOf(p), #0);
end;

procedure UA_BrowseRequest_init(out p: UA_BrowseRequest);
begin
  FillChar(p, SizeOf(p), #0);
end;

function UA_BrowseRequest_new: PUA_BrowseRequest;
begin
  result := UA_new(@UA_TYPES[UA_TYPES_BROWSEREQUEST]);
end;

function UA_BrowseRequest_copy(const src: UA_BrowseRequest; out
  dst: UA_BrowseRequest): UA_StatusCode;
begin
  result := UA_copy(@src, @dst, @UA_TYPES[UA_TYPES_BROWSEREQUEST]);
end;

procedure UA_BrowseRequest_deleteMembers(var p: UA_BrowseRequest);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_BROWSEREQUEST]);
end;

procedure UA_BrowseRequest_clear(var p: UA_BrowseRequest);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_BROWSEREQUEST]);
end;

procedure UA_BrowseRequest_delete(p: PUA_BrowseRequest);
begin
  UA_delete(p, @UA_TYPES[UA_TYPES_BROWSEREQUEST]);
end;

procedure UA_BrowseResponse_init(out p: UA_BrowseResponse);
begin
  FillChar(p, SizeOf(p), #0);
end;

function UA_BrowseResponse_new: PUA_BrowseResponse;
begin
  result := UA_new(@UA_TYPES[UA_TYPES_BROWSERESPONSE]);
end;

function UA_BrowseResponse_copy(const src: UA_BrowseResponse; out
  dst: UA_BrowseResponse): UA_StatusCode;
begin
  result := UA_copy(@src, @dst, @UA_TYPES[UA_TYPES_BROWSERESPONSE]);
end;

procedure UA_BrowseResponse_deleteMembers(var p: UA_BrowseResponse);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_BROWSERESPONSE]);
end;

procedure UA_BrowseResponse_clear(var p: UA_BrowseResponse);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_BROWSERESPONSE]);
end;

procedure UA_BrowseResponse_delete(p: PUA_BrowseResponse);
begin
  UA_delete(p, @UA_TYPES[UA_TYPES_BROWSERESPONSE]);
end;

procedure UA_BrowseDescription_init(out p: UA_BrowseDescription);
begin
  FillChar(p, SizeOf(p), #0);
end;

function UA_BrowseDescription_new: PUA_BrowseDescription;
begin
  result := UA_new(@UA_TYPES[UA_TYPES_BROWSEDESCRIPTION]);
end;

function UA_BrowseDescription_copy(const src: UA_BrowseDescription; out
  dst: UA_BrowseDescription): UA_StatusCode;
begin
  result := UA_copy(@src, @dst, @UA_TYPES[UA_TYPES_BROWSEDESCRIPTION]);
end;

procedure UA_BrowseDescription_deleteMembers(var p: UA_BrowseDescription);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_BROWSEDESCRIPTION]);
end;

procedure UA_BrowseDescription_clear(var p: UA_BrowseDescription);
begin
  UA_clear(@p, @UA_TYPES[UA_TYPES_BROWSEDESCRIPTION]);
end;

procedure UA_BrowseDescription_delete(p: PUA_BrowseDescription);
begin
  UA_delete(p, @UA_TYPES[UA_TYPES_BROWSEDESCRIPTION]);
end;

function UA_Variant_isEmpty(const v: PUA_Variant): Boolean;
begin
  Result := v^._type = nil;
end;

function UA_Variant_isScalar(const v: PUA_Variant): Boolean;
begin
  Result := (v^.arrayLength = 0) and (PByte(v^.data) > PByte(UA_EMPTY_ARRAY_SENTINEL));
end;

function UA_Variant_hasScalarType(const v: PUA_Variant; const _type: PUA_DataType): Boolean;
begin
  Result := UA_Variant_isScalar(v) and (_type = v^._type);
end;

function UA_Variant_hasArrayType(const v: PUA_Variant; const _type: PUA_DataType): Boolean;
begin
  Result := (not UA_Variant_isScalar(v)) and (_type = v^._type);
end;

function UA_Variant_getFloat(var v: UA_Variant): single;
begin
  Result := PUA_Float(v.data)^;
end;

function UA_Variant_getDouble(var v: UA_Variant): double;
begin
  Result := PUA_Double(v.data)^;
end;

function UA_Variant_getByte(var v: UA_Variant): Byte;
begin
  Result := PUA_Byte(v.data)^;
end;

function UA_Variant_getSmallint(var v: UA_Variant): Smallint;
begin
  Result := PUA_Int16(v.data)^;
end;

function UA_Variant_getInteger(var v: UA_Variant): Integer;
begin
  Result := PUA_Int32(v.data)^;
end;

function UA_Variant_getInt64(var v: UA_Variant): Int64;
begin
  Result := PUA_Int64(v.data)^;
end;

function UA_Variant_getString(var v: UA_Variant): AnsiString;
begin
  SetString(Result, PAnsiChar(PUA_String(v.data)^.data), PUA_String(v.data)^.length);
end;

function UA_Variant_getString(var v: UA_Variant; arrayIndex: DWord): AnsiString;
begin
  if arrayIndex < v.arrayLength then
    SetString(Result, PAnsiChar(PUA_String(v.data)[arrayIndex].data), PUA_String(v.data)[arrayIndex].length)
  else
    Result := '';
end;

procedure UA_Variant_setBoolean(out v: UA_Variant; b: bytebool);
begin
  UA_Variant_setScalarCopy(@v, @b, @UA_TYPES[UA_TYPES_BOOLEAN]);
end;

procedure UA_Variant_setFloat(out v: UA_Variant; f: single);
begin
  UA_Variant_setScalarCopy(@v, @f, @UA_TYPES[UA_TYPES_FLOAT]);
end;

procedure UA_Variant_setDouble(out v: UA_Variant; d: double);
begin
  UA_Variant_setScalarCopy(@v, @d, @UA_TYPES[UA_TYPES_DOUBLE]);
end;

procedure UA_Variant_setByte(out v: UA_Variant; i: Byte);
begin
  UA_Variant_setScalarCopy(@v, @i, @UA_TYPES[UA_TYPES_BYTE]);
end;

procedure UA_Variant_setSmallint(out v: UA_Variant; i: Smallint);
begin
  UA_Variant_setScalarCopy(@v, @i, @UA_TYPES[UA_TYPES_INT16]);
end;

procedure UA_Variant_setUInt16(out v: UA_Variant; i: UInt16);
begin
  UA_Variant_setScalarCopy(@v, @i, @UA_TYPES[UA_TYPES_UINT16]);
end;

procedure UA_Variant_setInteger(out v: UA_Variant; i: Integer);
begin
  UA_Variant_setScalarCopy(@v, @i, @UA_TYPES[UA_TYPES_INT32]);
end;

procedure UA_Variant_setUInt32(out v: UA_Variant; i: UInt32);
begin
  UA_Variant_setScalarCopy(@v, @i, @UA_TYPES[UA_TYPES_UINT32]);
end;

procedure UA_Variant_setInt64(out v: UA_Variant; i: Int64);
begin
  UA_Variant_setScalarCopy(@v, @i, @UA_TYPES[UA_TYPES_INT64]);
end;

procedure UA_Variant_setUInt64(out v: UA_Variant; i: UInt64);
begin
  UA_Variant_setScalarCopy(@v, @i, @UA_TYPES[UA_TYPES_UINT64]);
end;

procedure UA_Variant_setString(out v: UA_Variant; const s: AnsiString);
var
  uas: UA_STRING;
begin
  uas := _UA_STRING_ALLOC(s);
  UA_Variant_setScalarCopy(@v, @uas, @UA_TYPES[UA_TYPES_STRING]);
  UA_String_clear(@uas);
end;

function UA_NODEID_NUMERIC(nsIndex: UA_UInt16; identifier: UA_UInt32): UA_NodeId;
begin
  Result.namespaceIndex := nsIndex;
  Result.identifierType := UA_NODEIDTYPE_NUMERIC;
  Result.identifier.numeric := identifier;
end;

function UA_NODEID_STRING(nsIndex: UA_UInt16; var chars: AnsiString): UA_NodeId;
begin
  Result.namespaceIndex := nsIndex;
  Result.identifierType := UA_NODEIDTYPE_STRING;
  Result.identifier._string := _UA_STRING(chars);
end;

function UA_NODEID_STRING_ALLOC(nsIndex: UA_UInt16; const chars: AnsiString): UA_NodeId;
begin
  Result.namespaceIndex := nsIndex;
  Result.identifierType := UA_NODEIDTYPE_STRING;
  Result.identifier._string := _UA_STRING_ALLOC(chars);
end;

function UA_NODEID_GUID(nsIndex: UA_UInt16; guid: UA_Guid): UA_NodeId;
begin
  Result.namespaceIndex := nsIndex;
  Result.identifierType := UA_NODEIDTYPE_GUID;
  Result.identifier.guid := guid;
end;

function UA_NODEID_BYTESTRING(nsIndex: UA_UInt16; var chars: AnsiString): UA_NodeId;
begin
  Result.namespaceIndex := nsIndex;
  Result.identifierType := UA_NODEIDTYPE_BYTESTRING;
  Result.identifier.byteString := _UA_BYTESTRING(chars);
end;

function UA_NODEID_BYTESTRING_ALLOC(nsIndex: UA_UInt16; const chars: AnsiString): UA_NodeId;
begin
  Result.namespaceIndex := nsIndex;
  Result.identifierType := UA_NODEIDTYPE_BYTESTRING;
  Result.identifier.byteString := _UA_BYTESTRING_ALLOC(chars);
end;

function UA_EXPANDEDNODEID_NUMERIC(nsIndex: UA_UInt16; identifier: UA_Uint32): UA_ExpandedNodeId;
begin
  result.nodeId := UA_NODEID_NUMERIC(nsIndex, identifier);
  result.serverIndex := 0;
  result.namespaceUri := UA_STRING_NULL;
end;

procedure UA_init(p: Pointer; const _type: PUA_DataType);
begin
  FillChar(p^, _type^.memSize, #0);
end;

function UA_Client_connect_username(client: PUA_Client; const endpointUrl, username, password: AnsiString): UA_StatusCode;
begin
  Result := UA_Client_connectUsername(client, endpointUrl, username, password);
end;

function UA_Client_connectUsername(client: PUA_Client; const endpointUrl, username, password: AnsiString): UA_StatusCode;
var
  identityToken: PUA_UserNameIdentityToken;
  cc: PUA_ClientConfig;
begin
  identityToken := PUA_UserNameIdentityToken(UA_new(@UA_TYPES[UA_TYPES_USERNAMEIDENTITYTOKEN]));
  if identityToken = nil then
    Result := UA_STATUSCODE_BADOUTOFMEMORY
  else begin
    identityToken^.userName := _UA_STRING_ALLOC(username);
    identityToken^.password := _UA_STRING_ALLOC(password);
    cc := UA_Client_getConfig(client);
    UA_clear(@cc^.userIdentityToken, @UA_TYPES[UA_TYPES_EXTENSIONOBJECT]);
    cc^.userIdentityToken.encoding := UA_EXTENSIONOBJECT_DECODED;
    cc^.userIdentityToken.content.decoded._type := @UA_TYPES[UA_TYPES_USERNAMEIDENTITYTOKEN];
    cc^.userIdentityToken.content.decoded.data := identityToken;
    Result := OpcUaClientConnect(client, @endpointUrl);
  end;
end;

function UA_Client_Service_read(client: PUA_Client; const request: UA_ReadRequest): UA_ReadResponse;
begin
  __UA_Client_Service(client, @request, @UA_TYPES[UA_TYPES_READREQUEST], @Result, @UA_TYPES[UA_TYPES_READRESPONSE]);
end;

function UA_Client_Service_browse(client: PUA_Client; const request: UA_BrowseRequest): UA_BrowseResponse;
begin
  __UA_Client_Service(client, @request, @UA_TYPES[UA_TYPES_BROWSEREQUEST], @Result, @UA_TYPES[UA_TYPES_BROWSERESPONSE]);
end;

function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: UA_Variant): UA_StatusCode; overload;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUE, @outValue, @UA_TYPES[UA_TYPES_VARIANT]);
end;

function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const indexRange: AnsiString; out outValue: UA_Variant): UA_StatusCode; overload;
var
  item: UA_ReadValueId;
  request: UA_ReadRequest;
  response: UA_ReadResponse;
begin
  FillChar(item, sizeof(UA_ReadValueId), #0);
  item.nodeId := nodeId;
  item.attributeId := ord(UA_ATTRIBUTEID_VALUE);
  item.indexRange := _UA_STRING_ALLOC(indexRange);
  FillChar(request, sizeof(UA_ReadRequest), #0);
  request.nodesToRead := @item;
  request.nodesToReadSize := 1;
  response := UA_Client_Service_read(client, request);
  Result := response.responseHeader.serviceResult;
  if Result = UA_STATUSCODE_GOOD then begin
    if response.resultsSize = 1 then
      Result := response.results[0].status
    else
      Result := UA_STATUSCODE_BADUNEXPECTEDERROR;
  end;

  if Result = UA_STATUSCODE_GOOD then begin
    if response.results^.flag and 2 <> 0 then
      Result := response.results^.status;

    if response.results^.flag and 1 <> 0 then begin
      outValue := response.results^.value;
      UA_Variant_init(response.results^.value);
    end else
      Result := UA_STATUSCODE_BADUNEXPECTEDERROR;
  end;

  UA_clear(@response, @UA_TYPES[UA_TYPES_READRESPONSE]);
  UA_String_clear(@item.indexRange);
end;

function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: Byte): UA_StatusCode;
var
  value: UA_Variant;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUE, @value, @UA_TYPES[UA_TYPES_VARIANT]);
  if Result = UA_STATUSCODE_GOOD then begin
    if UA_Variant_hasScalarType(@value, @UA_TYPES[UA_TYPES_BYTE]) then
      outValue := PUA_Byte(value.data)^
    else
      Result := UA_STATUSCODE_BADTYPEMISMATCH;
  end;
  UA_Variant_clear(value);
end;

function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: Smallint): UA_StatusCode;
var
  value: UA_Variant;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUE, @value, @UA_TYPES[UA_TYPES_VARIANT]);
  if Result = UA_STATUSCODE_GOOD then begin
    if UA_Variant_hasScalarType(@value, @UA_TYPES[UA_TYPES_INT16]) then
      outValue := PUA_Int16(value.data)^
    else
      Result := UA_STATUSCODE_BADTYPEMISMATCH;
  end;
  UA_Variant_clear(value);
end;

function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: Longint): UA_StatusCode; overload;
var
  value: UA_Variant;
begin
  UA_Variant_init(value);
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUE, @value, @UA_TYPES[UA_TYPES_VARIANT]);
  if Result = UA_STATUSCODE_GOOD then begin
    if UA_Variant_hasScalarType(@value, @UA_TYPES[UA_TYPES_INT32]) then
      outValue := PUA_Int32(value.data)^
    else
      Result := UA_STATUSCODE_BADTYPEMISMATCH;
  end;
  UA_Variant_clear(value);
end;

function UA_Client_readValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValue: AnsiString): UA_StatusCode; overload;
var
  value: UA_Variant;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUE, @value, @UA_TYPES[UA_TYPES_VARIANT]);
  if Result = UA_STATUSCODE_GOOD then begin
    if UA_Variant_hasScalarType(@value, @UA_TYPES[UA_TYPES_STRING]) then
      SetString(outValue, PAnsiChar(PUA_String(value.data)^.data), PUA_String(value.data)^.length)
    else
      Result := UA_STATUSCODE_BADTYPEMISMATCH;
  end;
  UA_Variant_clear(value);
end;

function UA_Client_readDataTypeAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outDataType: UA_NodeId): UA_StatusCode;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_DATATYPE, @outDataType, @UA_TYPES[UA_TYPES_NODEID]);
end;

function UA_Client_readValueRankAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outValueRank: UA_Int32): UA_StatusCode;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUERANK, @outValueRank, @UA_TYPES[UA_TYPES_INT32]);
end;

function UA_Client_readBrowseNameAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outBrowseName: UA_QualifiedName): UA_StatusCode;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_BROWSENAME, @outBrowseName, @UA_TYPES[UA_TYPES_QUALIFIEDNAME]);
end;

function UA_Client_readDisplayNameAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outDisplayName: UA_LocalizedText): UA_StatusCode;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_DISPLAYNAME, @outDisplayName, @UA_TYPES[UA_TYPES_LOCALIZEDTEXT]);
end;

function UA_Client_readDescriptionAttribute(client: PUA_Client; const nodeId: UA_NodeId; out outDescription: UA_LocalizedText): UA_StatusCode;
begin
  Result := __UA_Client_readAttribute(client, @nodeId, UA_ATTRIBUTEID_DESCRIPTION, @outDescription, @UA_TYPES[UA_TYPES_LOCALIZEDTEXT]);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Variant): UA_StatusCode;
begin
  Result := __UA_Client_writeAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUE, @newValue, @UA_TYPES[UA_TYPES_VARIANT]);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Double): UA_StatusCode;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_DOUBLE]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: Byte): UA_StatusCode;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_BYTE]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: Smallint): UA_StatusCode;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_INT16]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: Longint): UA_StatusCode;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_INT32]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: AnsiString): UA_StatusCode;
var
  uav: UA_Variant; uas: UA_String;
begin
  uas := _UA_STRING_ALLOC(newValue);
  UA_Variant_setScalar(@uav, @uas, @UA_TYPES[UA_TYPES_STRING]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
  UA_String_clear(@uas);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValues: array of AnsiString): UA_StatusCode; overload;
var
  uav: UA_Variant; uas: array of UA_String; i: integer;
begin
  SetLength(uas, Length(newValues));
  for i := Low(newValues) to High(newValues) do
    uas[i] := _UA_STRING_ALLOC(newValues[i]);
  UA_Variant_setArray(@uav, @uas[0], Length(uas), @UA_TYPES[UA_TYPES_STRING]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
  for i := Low(newValues) to High(newValues) do
    UA_String_clear(@uas[i]);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Boolean): UA_StatusCode; overload;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_BOOLEAN]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_UInt16): UA_StatusCode; overload;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_UINT16]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_UInt32): UA_StatusCode; overload;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_UINT32]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Int64): UA_StatusCode; overload;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_INT64]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_Float): UA_StatusCode; overload;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_FLOAT]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_ByteString): UA_StatusCode; overload;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_BYTESTRING]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeValueAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValue: UA_LocalizedText): UA_StatusCode; overload;
var
  uav: UA_Variant;
begin
  UA_Variant_setScalar(@uav, @newValue, @UA_TYPES[UA_TYPES_LOCALIZEDTEXT]);
  Result := UA_Client_writeValueAttribute(client, nodeId, uav);
end;

function UA_Client_writeDescriptionAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newDescription: UA_LocalizedText): UA_StatusCode;
begin
  Result := __UA_Client_writeAttribute(client, @nodeId, UA_ATTRIBUTEID_DESCRIPTION, @newDescription, @UA_TYPES[UA_TYPES_LOCALIZEDTEXT]);
end;

function UA_Client_writeDataTypeAttribute(client: PUA_Client; const nodeId: UA_NodeId; newDataType: PUA_NodeId): UA_StatusCode;
begin
  Result := __UA_Client_writeAttribute(client, @nodeId, UA_ATTRIBUTEID_DATATYPE, newDataType, @UA_TYPES[UA_TYPES_NODEID]);
end;

function UA_Client_writeValueRankAttribute(client: PUA_Client; const nodeId: UA_NodeId; const newValueRank: UA_Int32): UA_StatusCode;
begin
  Result := __UA_Client_writeAttribute(client, @nodeId, UA_ATTRIBUTEID_VALUERANK, @newValueRank, @UA_TYPES[UA_TYPES_INT32]);
end;

function UA_CreateSubscriptionRequest_default(): UA_CreateSubscriptionRequest;
begin
  UA_CreateSubscriptionRequest_init(Result);
  Result.requestedPublishingInterval := 500.0;
  Result.requestedLifetimeCount := 10000;
  Result.requestedMaxKeepAliveCount := 10;
  Result.maxNotificationsPerPublish := 0;
  Result.publishingEnabled := True;
  Result.priority := 0;
end;

function UA_MonitoredItemCreateRequest_default(nodeId: UA_NodeId): UA_MonitoredItemCreateRequest;
begin
  UA_MonitoredItemCreateRequest_init(Result);
  Result.itemToMonitor.nodeId := nodeId;
  Result.itemToMonitor.attributeId := Ord(UA_ATTRIBUTEID_VALUE);
  Result.monitoringMode := UA_MONITORINGMODE_REPORTING;
  Result.requestedParameters.samplingInterval := 500;
  Result.requestedParameters.discardOldest := true;
  Result.requestedParameters.queueSize := 1;
end;

function UA_ServerConfig_setDefault(config: PUA_ServerConfig): UA_StatusCode;
begin
  Result := UA_ServerConfig_setMinimal(config, 4840, nil);
end;

function UA_ServerConfig_setMinimal(config: PUA_ServerConfig; portNumber: UA_UInt16; const certificate: PUA_ByteString): UA_StatusCode;
begin
  Result := UA_ServerConfig_setMinimalCustomBuffer(config, portNumber, certificate, 0, 0);
end;

function UA_Server_addVariableNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const typeDefinition: UA_NodeId;
  const attr: UA_VariableAttributes;
  nodeContext: Pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  Result := __UA_Server_addNode(server, UA_NODECLASS_VARIABLE, @requestedNewNodeId,
    @parentNodeId, @referenceTypeId, browseName,
    @typeDefinition, PUA_NodeAttributes(@attr),
    @UA_TYPES[UA_TYPES_VARIABLEATTRIBUTES],
    nodeContext, outNewNodeId);
end;

function UA_Server_addObjectTypeNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_ObjectTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  result := __UA_Server_addNode(server, UA_NODECLASS_OBJECTTYPE, @requestedNewNodeId,
    @parentNodeId, @referenceTypeId, browseName,
    @UA_NODEID_NULL, @attr,
    @UA_TYPES[UA_TYPES_OBJECTTYPEATTRIBUTES],
    nodeContext, outNewNodeId);
end;

function UA_Server_addObjectNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const typeDefinition: UA_NodeId;
  const attr: UA_ObjectAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  result := __UA_Server_addNode(server, UA_NODECLASS_OBJECT, @requestedNewNodeId,
    @parentNodeId, @referenceTypeId, browseName,
    @typeDefinition, @attr,
    @UA_TYPES[UA_TYPES_OBJECTATTRIBUTES],
    nodeContext, outNewNodeId);
end;

function UA_Server_addVariableTypeNode(server: PUA_Server;
  const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const typeDefinition: UA_NodeId;
  const attr: UA_VariableTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  result := __UA_Server_addNode(server, UA_NODECLASS_VARIABLETYPE,
    @requestedNewNodeId, @parentNodeId, @referenceTypeId,
    browseName, @typeDefinition,
    @attr,
    @UA_TYPES[UA_TYPES_VARIABLETYPEATTRIBUTES],
    nodeContext, outNewNodeId);
end;

function UA_Server_addViewNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_ViewAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  result := __UA_Server_addNode(server, UA_NODECLASS_VIEW, @requestedNewNodeId,
    @parentNodeId, @referenceTypeId, browseName,
    @UA_NODEID_NULL, @attr,
    @UA_TYPES[UA_TYPES_VIEWATTRIBUTES],
    nodeContext, outNewNodeId);
end;

function UA_Server_addReferenceTypeNode(server: PUA_Server;
  const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_ReferenceTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  result := __UA_Server_addNode(server, UA_NODECLASS_REFERENCETYPE,
    @requestedNewNodeId, @parentNodeId, @referenceTypeId,
    browseName, @UA_NODEID_NULL,
    @attr,
    @UA_TYPES[UA_TYPES_REFERENCETYPEATTRIBUTES],
    nodeContext, outNewNodeId);
end;

function UA_Server_addDataTypeNode(server: PUA_Server;
  const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_DataTypeAttributes;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  result := __UA_Server_addNode(server, UA_NODECLASS_DATATYPE, @requestedNewNodeId,
    @parentNodeId, @referenceTypeId, browseName,
    @UA_NODEID_NULL, @attr,
    @UA_TYPES[UA_TYPES_DATATYPEATTRIBUTES],
    nodeContext, outNewNodeId);
end;

function UA_Server_writeValue(server: PUA_Server; const nodeId: UA_NodeId; const value: UA_Variant): UA_StatusCode;
begin
  Result := __UA_Server_write(server, @nodeId, UA_ATTRIBUTEID_VALUE, @UA_TYPES[UA_TYPES_VARIANT], @value);
end;

function UA_Server_addMethodNode(server: PUA_Server; const requestedNewNodeId: UA_NodeId;
  const parentNodeId: UA_NodeId;
  const referenceTypeId: UA_NodeId;
  const browseName: UA_QualifiedName;
  const attr: UA_MethodAttributes; method: UA_MethodCallback;
  inputArgumentsSize: SIZE_T; const inputArguments: PUA_Argument;
  outputArgumentsSize: SIZE_T; const outputArguments: PUA_Argument;
  nodeContext: pointer; outNewNodeId: PUA_NodeId): UA_StatusCode;
begin
  result := UA_Server_addMethodNodeEx(server, requestedNewNodeId, parentNodeId,
    referenceTypeId, browseName, attr, method,
    inputArgumentsSize, inputArguments, UA_NODEID_NULL, nil,
    outputArgumentsSize, outputArguments, UA_NODEID_NULL, nil,
    nodeContext, outNewNodeId);
end;

end.

